// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Plugins/Preview/hctPreviewAsset.h>

#include <Common/SceneData/Environment/hkxEnvironment.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Texture/SkyBox/hkgSkyBox.h>

#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Graphics/Common/Shader/hkgShaderLib.h>

#ifdef HK_ENABLE_PHYSICS_2012
#include <Common/Visualize/hkProcess.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpShapeDisplayViewer.h> 
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpConvexRadiusViewer.h> 
#endif

#ifdef HK_ENABLE_PHYSICS
#include <Physics/Physics/Dynamics/World/hknpWorld.h>                   
#include <Physics/Physics/Extensions/Viewers/Shape/hknpShapeViewer.h>   
#endif

#if HK_ENABLE_DESTRUCTION_2012
#include <Common/Base/Serialize/ResourceHandle/hkResourceHandle.h>
#include <Destruction2012/Destruction/Action/MeshOptimizer/hkdMeshOptimizerInfo.h> 
#endif

using namespace PreviewPlugin;
using namespace System::IO;


void PreviewAssetManager::setupSkyBox(const char* skyBoxFileName)
{
    hkStringOld defaultPath = m_shaderLibDir + "\\textures\\";

    hkStringOld skyBoxFileNamePath;
    if (!skyBoxFileName)
    {
        skyBoxFileNamePath = m_shaderLibDir + "\\textures\\defaultskybox";
    }
    else
    {
        skyBoxFileNamePath = skyBoxFileName;
    }

    hkArray<int> hits;
    hkString::findAllOccurrences( skyBoxFileNamePath.cString(), "\\", hits, hkString::REPLACE_ALL );
    if (hits.isEmpty())
    {
        hkString::findAllOccurrences( skyBoxFileNamePath.cString(), "/", hits, hkString::REPLACE_ALL );
    }
    hkStringOld rootName;
    if (hits.isEmpty())
    {
        rootName = defaultPath + skyBoxFileName;
    }
    else
    {
        rootName = skyBoxFileName;
    }

    hkStringOld upName = rootName + "_UP.png";
    hkStringOld downName = rootName + "_DN.png";
    hkStringOld leftName = rootName + "_LF.png";
    hkStringOld rightName = rootName + "_RT.png";
    hkStringOld frontName = rootName + "_FR.png";
    hkStringOld backName = rootName + "_BK.png";

    // see which way is 'up'
    hkgCamera* cam = m_displayContext->getCurrentViewport()->getCamera();

    float worldUp[3];
    cam->getBestAlignedUpVector(worldUp);

    hkgSkyBox* sky = hkgSkyBox::create();
    sky->setUp( worldUp );

    const char* names[] = { upName.cString(), downName.cString(), leftName.cString(), rightName.cString(), frontName.cString(), backName.cString() };
    for (int i=0; i < 6; ++i)
    {
        hkIstream s(names[i]);
        if (!s.isOk())
            continue;

        hkgTexture* t = hkgTexture::create(m_displayContext);
        t->loadFromPNG(s);
        t->realize();
        t->setTextureWrapModeU(HKG_TEXTURE_CLAMP);
        t->setTextureWrapModeV(HKG_TEXTURE_CLAMP);
        sky->setTexture((HKG_SKYBOX_TEXTURE)i, t, 0xffffffff );
        t->removeReference();
    }

    m_displayContext->getCurrentViewport()->setSkyBox(sky);
    sky->removeReference();
}

//
//  Creates the scene converter, but does not convert anything yet. Returns true if the asset manager should convert

bool PreviewAssetManager::createSceneConverter(PreviewAsset* asset, hkUint32& convMask)
{
    hkRootLevelContainer* root = asset->m_container;

    bool alreadyConverted = false;
    if (asset->m_convertedGraphicsObjects == HK_NULL)
    {
        asset->m_convertedGraphicsObjects = new hkgSceneDataConverter(m_displayWorld, m_displayContext);
    }
    else
    {
        alreadyConverted = true;
    }

    hkxScene* scene = root->findObject<hkxScene>();
    if (scene && m_displayWorld && m_displayContext)
    {
        m_displayContext->lock();

        if ( !alreadyConverted )
        {
            bool haveShaderDir = (m_shaderLibDir.getLength() > 0);
            bool haveShaderSupport = asset->m_convertedGraphicsObjects->m_shaderLibrary && (m_displayContext->getRenderCaps().m_vertexShaderMajorVersion >= 2 );
            asset->m_shaderSupport = haveShaderDir && haveShaderSupport;

            // allow absolute texture paths
            asset->m_convertedGraphicsObjects->m_materialCache.m_removeDriveLetterFromPath = false;

            bool hwSkinning = false;    // TODO!    // m_displayWorld->getHardwareSkinning();
            asset->m_convertedGraphicsObjects->setAllowHardwareSkinning( hwSkinning );

            bool diffuseOnly = true;
            if (asset->m_shaderSupport)
            {
                asset->m_convertedGraphicsObjects->m_shaderLibrary->clearSearchPaths();
                asset->m_convertedGraphicsObjects->m_shaderLibrary->addSearchPath( m_shaderLibDir.cString() );
                asset->m_convertedGraphicsObjects->setShaderLibraryEnabled(true);
                asset->m_convertedGraphicsObjects->m_shaderLibrary->setAutoLoadShaderTypes( true, true, false );

                diffuseOnly = false;
            }
            else
            {
                asset->m_convertedGraphicsObjects->setShaderLibraryEnabled(false);
                if (!haveShaderDir)
                {
#ifdef HK_PLATFORM_WIN64
                    HK_WARN_ALWAYS(0xabbaabf4, "No shader library found. Check your HAVOK_TOOLS_ROOT_X64 env var HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools_x64\\ShaderLib regkey path. See the Help->About for list of current settings. Assets will now only load diffuse textures. ");
#else
                    HK_WARN_ALWAYS(0xabba48d0, "No shader library found. Check your HAVOK_TOOLS_ROOT env var or HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools\\ShaderLib regkey path. Assets will now only load diffuse textures. ");
#endif
                }
                else if (!haveShaderSupport)
                {
                    HK_WARN_ALWAYS(0xabba78a1, "Can't use shader library as your graphics card does not support Shader Model 2 or higher. Assets will now only load diffuse textures. ");
                }
            }

            // get some paths where texture might be
            {
                asset->m_convertedGraphicsObjects->clearTextureSearchPaths();
                for (int i=0; i<m_texPaths.getSize(); ++i)
                {
                    asset->m_convertedGraphicsObjects->addTextureSearchPath(m_texPaths[i]->cString());
                }

                hkxEnvironment* sceneEnv = root->findObject<hkxEnvironment>();
                if (sceneEnv)
                {
                    const char* folder = sceneEnv->getVariableValue("assetFolder");
                    if (folder)
                    {
                        hkStringOld* texPathStorage = new hkStringOld(folder);
                        m_texPaths.pushBack(texPathStorage);
                        asset->m_convertedGraphicsObjects->addTextureSearchPath(texPathStorage->cString());
                    }

                    const char* searchPath = sceneEnv->getVariableValue("textureSearchPath");
                    if (searchPath)
                    {
                        hkStringOld* texPathStorage = new hkStringOld(searchPath);
                        m_texPaths.pushBack(texPathStorage);
                        asset->m_convertedGraphicsObjects->addTextureSearchPath(texPathStorage->cString());
                    }
                }

                hkArray<int> hits;
                hkString::findAllOccurrences( asset->m_filename.cString(), "\\", hits, hkString::REPLACE_ALL );
                if (hits.isEmpty())
                {
                    hkString::findAllOccurrences( asset->m_filename.cString(), "/", hits, hkString::REPLACE_ALL );
                }
                if (!hits.isEmpty())
                {
                    int lastIndex = hits.back();
                    hkStringOld texPath = asset->m_filename.substr( 0, lastIndex );
                    hkStringOld* texPathStorage = new hkStringOld(texPath);
                    m_texPaths.pushBack(texPathStorage);
                    asset->m_convertedGraphicsObjects->addTextureSearchPath(texPathStorage->cString());
                }
            }

            asset->m_convertedGraphicsObjects->setAllowExtraTextures(true);
            asset->m_convertedGraphicsObjects->setAllowTextureAnisotropicFilter(true);

            convMask = hkgAssetConverter::CONVERT_ALL;
            if (diffuseOnly)
            {
                convMask = convMask | hkgAssetConverter::FORCE_DIFFUSE_MAT_ONLY;
            }

#if HK_ENABLE_DESTRUCTION_2012
            // Look for destruction optimizer info and keep skinning data if necessary
            hkResourceContainer* resourceContainer = reinterpret_cast<hkResourceContainer*>(root->findObjectByName("Resource Data"));
            if ( resourceContainer )
            {
                for (hkResourceContainer* container = resourceContainer->findContainerByName(HK_NULL, HK_NULL); container;  container = resourceContainer->findContainerByName(HK_NULL, container))
                {
                    hkdMeshOptimizerInfo* optimizerInfo = container->findResource<hkdMeshOptimizerInfo>(HK_NULL);
                    if ( optimizerInfo && optimizerInfo->m_optimizationType == hkdMeshOptimizerInfo::SKIN )
                    {
                        asset->m_convertedGraphicsObjects->setKeepSkinningData(true);
                        break;
                    }
                }
            }
#endif

            m_displayContext->unlock();
            return true;
        }

        // Have converted already, just need to re-add the lights / objects / etc
        m_displayContext->unlock();
    }

    return false;   // Don't convert anything!
}

void PreviewAssetManager::addGraphicsObjects( PreviewAsset* asset, hkgDefaultSceneDataFilter* filter, bool shouldConvert, bool shouldAdd, hkUint32 convMask)
{
    hkRootLevelContainer* root  = asset->m_container;
    hkxScene* scene             = root->findObject<hkxScene>();

    if ( scene && m_displayWorld && m_displayContext )
    {
        m_displayContext->lock();

        if ( shouldConvert )
        {
            asset->m_convertedGraphicsObjects->convert(scene, (hkgAssetConverter::ConvertMask)convMask, shouldAdd, filter);
        }
        else if ( shouldAdd )
        {
            asset->m_convertedGraphicsObjects->addCreatedObjectsBackIntoWorld();
        }

        m_displayContext->unlock();
    }
}

void PreviewAssetManager::removeGraphicsObjects( PreviewAsset* asset )
{
    if (asset->m_convertedGraphicsObjects != HK_NULL)
    {
        asset->m_convertedGraphicsObjects->removeCreatedObjectsFromWorld(false);
    }
}

void PreviewAssetManager::toggleRbDisplay(bool on)
{
    m_hideRbMeshes = !on;

    // Anything geom in the displayhandler that has a precreated display should be a RB mesh
    if ( m_displayHandler )
    {
#ifdef HK_ENABLE_PHYSICS_2012
        const hkPointerMap<hkUint64, hkgDisplayObject*>& objMap = m_displayHandler->getObjectMap();
        hkPointerMap<hkUint64, hkgDisplayObject*>::Iterator iter = objMap.getIterator();
        while (objMap.isValid(iter))
        {
            hkgDisplayObject* obj = m_displayHandler->getPrecreatedDisplayObject( objMap.getKey(iter) );
            if (obj)
            {
                if (on)
                {
                    if (!m_displayWorld->containsDisplayObject(obj))
                    {
                        m_displayWorld->addDisplayObject(obj);
                    }
                }
                else
                {
                    if (m_displayWorld->removeDisplayObject(obj))
                    {
                        obj->removeReference();
                    }
                }
            }

            iter = objMap.getNext(iter);
        }
#endif
#ifdef HK_ENABLE_PHYSICS
        if (m_npShapeViewer)
        {
            hkArray<hknpBodyId> ids;
            {
                hknpBodyIterator itr = m_currentNpWorld->getBodyIterator();
                while(itr.isValid())
                {
                    ids.pushBack(itr.getBodyId());
                    itr.next();
                }
            }
            for (int idi = 0; idi < ids.getSize(); idi++)
            {
                hkUint64 displayId = m_npShapeViewer->composeDisplayObjectId(hknpProcessContext::WorldId(0), ids[idi]);
                hkgDisplayObject* displayObj = m_displayHandler->getPrecreatedDisplayObject(displayId);
                if (displayObj)
                {
                    if (on)
                    {
                        if (!m_displayWorld->containsDisplayObject(displayObj))
                        {
                            m_displayWorld->addDisplayObject(displayObj);
                        }
                    }
                    else
                    {
                        if (m_displayWorld->removeDisplayObject(displayObj))
                        {
                            displayObj->removeReference();
                        }
                    }
                }
            }
        }
#endif
    }
}

void PreviewAssetManager::toggleGhostTransparency( bool on )
{
    m_ghostsEnabled = on;

#ifdef HK_ENABLE_PHYSICS_2012
    if (m_ghostDisplayHandler && (m_ghostProcesses.getSize() == 2))
    {
        const hkPointerMap<hkUint64, hkgDisplayObject*>& ghosts = m_ghostDisplayHandler->getObjectMap();
        hkPointerMap<hkUint64, hkgDisplayObject*>::Iterator it = ghosts.getIterator();

        if (on)
        {
            for ( ; ghosts.isValid(it); it = ghosts.getNext(it))
            {
                const hkUint64 id = ghosts.getKey(it);
                if (( id & 0x03) == 0x03) // convex radius
                {
                    m_ghostDisplayHandler->setGeometryColor( id, ALPHA_PHYSICS_RADIUS_COLOR );
                }
                else
                {
                    m_ghostDisplayHandler->setGeometryColor( id, ALPHA_PHYSICS_COLOR );
                }
            }
        }
        else
        {
            for ( ; ghosts.isValid(it); it = ghosts.getNext(it))
            {
                const hkUint64 id = ghosts.getKey(it);
                m_ghostDisplayHandler->setGeometryColor( id, ALPHA_PHYSICS_TRANSPARENT );
            }
        }

        // And change for any new objs to be created (from Destruction etc)
        hkpShapeDisplayViewer* sv = (hkpShapeDisplayViewer*)( m_ghostProcesses[0] );
        sv->setFixedObjectColor( on ? ALPHA_PHYSICS_COLOR : ALPHA_PHYSICS_TRANSPARENT );
        sv->setMovableObjectColor( on ? ALPHA_PHYSICS_COLOR : ALPHA_PHYSICS_TRANSPARENT );

        hkpConvexRadiusViewer* cv = (hkpConvexRadiusViewer*)( m_ghostProcesses[1] );
        cv->setFixedObjectColor( on ? ALPHA_PHYSICS_RADIUS_COLOR : ALPHA_PHYSICS_TRANSPARENT );
        cv->setMovableObjectColor( on ? ALPHA_PHYSICS_RADIUS_COLOR : ALPHA_PHYSICS_TRANSPARENT );
    }
#endif

#ifdef HK_ENABLE_PHYSICS
    if (m_npGhostDisplayHandler)
    {
        // CK : removing the world makes all display ids used created by the shapeveiwer in NP invalid
        //      We need them to always be valid even when not showing the ghost so that we can pick and pull around the precreated (exported) mesh ver
        //      Currently the shapeviewer in NP does not support that, so we just have to alpha out the geoms (hkg will not draw them at all anyway if masked like tha so not too bad)

        const hkPointerMap<hkUint64, hkgDisplayObject*>& ghosts = m_npGhostDisplayHandler->getObjectMap();
        hkPointerMap<hkUint64, hkgDisplayObject*>::Iterator it = ghosts.getIterator();

        hkColor::Argb color = on ? ALPHA_PHYSICS_COLOR : ALPHA_PHYSICS_TRANSPARENT;
        for ( ; ghosts.isValid(it); it = ghosts.getNext(it))
        {
            m_npGhostDisplayHandler->setGeometryColor( ghosts.getKey(it), color );
        }

        // And change for any new objs to be created (from Destruction etc)
        if (m_colorScheme)
        {
            m_colorScheme->m_dontCollideColor = color;
            m_colorScheme->m_keyframedBodyColor = color;
            m_colorScheme->m_dynamicBodyColor = color;
            m_colorScheme->m_staticBodyColor = color;
        }
    }
#endif
}

void PreviewAssetManager::toggleBbDisplay(bool displayMeshes)
{
    m_hideBbMeshes = !displayMeshes;

#ifdef HK_ENABLE_DESTRUCTION_2012
    toggleDestructionBodiesDisplay();
#endif

#ifdef HK_ENABLE_DESTRUCTION
    toggleNdBodiesDisplay();
#endif
}

#pragma managed

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
