// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>
#include <Common/Visualize/hkServerObjectHandler.h>

// Base
class hkRootLevelContainer;
class hkResource;
class hkStreamReader;
class hkJobQueue;
class hkDefaultTaskQueue;
class hkProcess;
class hkThreadPool;
class hkCpuThreadPool;

// Graphics
class hkgDisplayWorld;
class hkgDisplayContext;
class hkgDisplayHandler;
class hkgDisplayObject;
class hkgSceneDataConverter;
class hkgDefaultSceneDataFilter;

class hkxScene;

// Phys
class hkpWorld;
class hkpPhysicsContext;
class hkpRigidBody;

// New Phys
class hknpWorld;
class hknpProcessContext;
class hknpBody;
class hknpPhysicsSystem;
class hknpMultiThreadedShapeViewer;
class hknpDefaultViewerColorScheme;
class hkBlockStreamAllocator;
class hknpBodyManager;
class hknpMotionManager;
class hknpConstraintManager;
struct hknpEventHandlerInput;
struct hknpEvent;
class hknpFirstPersonGun;

// Anim
class hkaAnimatedSkeleton;
class hkaAnimationControl;
class hkaSkeleton;
class hkaAnimationBinding;
class hkaAnimationPreviewColorContainer;
class hkaFootstepAnalysisInfoContainer;
class hkaPose;


// Complete
class hkaSkeletonMapper;
class hkaRagdollInstance;
class hknpRagdoll;

// Cloth
class hclWorld;
class hkgClothPicking;
class hkgClothDisplayCache;
class hkgClothSetupMeshChannelViewer;
class hkgClothStorageMeshConverter;
class hclClothInstance;
class hclTransformSet;
class hclCollidable;
class hclTransitionConstraintInstanceData;
struct hclClothContainer;
class hclClothSetupObject;
class hclPhysics2012ClothWorld;
class hclPhysicsClothWorld;
class hclClothContext;

// Destruction
class hkdWorld;
class hkdMeshShapeRegistry;
class hkdGraphicsSystem;
class hkgMeshSystem;
class hkdMouseSpringReattachUtil;
class hkdExplodedViewUtil;
class hkdBreakableBodyResetUtil;
class hkdDestructionDemoConfig;
class hkdDeformableSkinningUtil;
class hkdBreakableBody;
class hkdDecalMapRuntime;
class hkpFirstPersonGun;
class hkpRigidBodyResetUtil;
class hkdBreakableBodyListener;

// New Destruction
class hkndWorld;
class hkndDestructionDemoConfig;
class hkngGraphicsSystem;
class hkndMeshShapeRegistry;
class hkndDestructionSystem;
class hkndExplodedViewUtil;
class hkndProcessContext;
class hkndFracturePieceNameViewer;
class hkndAssetManager;
class hkgBreakableEntity;
class hkgDebrisEntity;

#define HK_PREVIEW_MULTITHREADED_PHYSICS 0

#define ALPHA_PHYSICS_COLOR 0x7f0f0fef // blue
#define ALPHA_PHYSICS_RADIUS_COLOR 0x3f3f1f7f // redish purple, less alpha
#define ALPHA_PHYSICS_TRANSPARENT 0x00FEDCBA // transparent 

#define USER_TYPE_DISPLAY_OBJECT_NEW_PHYSICS 0x87cd923a

namespace PreviewPlugin {

    class PreviewAsset : public hkReferencedObject
    {
    public:

        PreviewAsset();
        virtual ~PreviewAsset();


        hkRootLevelContainer*   m_container; // just a list of variants, so should be able to represent anything
        hkResource*         m_rootMem; // will be null if not from HKX (so from filter pipeline etc)

        hkgSceneDataConverter*  m_convertedGraphicsObjects;

        const char* getName(); // will be null if container has no scenedata for now

        // some util funcs
        void clear();
        void loadFromStream( hkStreamReader* r );
        void loadFromFile( const char* fullPath );

        hkResult makeRewindPoint(void* reg); // then you can call loadFromStream on the m_rewindPoint to make a new Asset copy etc

        enum ModellerType
        {
            MODELLER_INVALID = -1,
            MODELLER_MAYA,
            MODELLER_3DS_MAX,
            MODELLER_XSI
        };
        ModellerType getModeller() const; // will be -1 if container has no scenedata or modeller name is unknown

        // Some per asset anim data
        hkArray<hkgDisplayObject*> m_attachmentObjects;
        hkaAnimationPreviewColorContainer* m_animPreviewColor;
        hkaFootstepAnalysisInfoContainer* m_animFootstepAnalysisInfo;

        // The master map from each instance collidable to a template collidable in the cloth container
        hkPointerMap<const hclCollidable*, const hclCollidable*> m_instanceCollidableToTemplateCollidable;

        // Map from template collidables to bone indices in m_collidablesSkel (index is -1 if collidable not associated with a bone)
        hkPointerMap<const hclCollidable*, int> m_templateCollidableToBoneIndex;

        hkaAnimatedSkeleton* m_collidablesSkel;
        hkArray<hkQsTransform> m_collidablesPose;
        hkaSkeletonMapper* m_animationToClothCollidablesMapper;

        // Note: If the asset doesn't contain any cloth related data, then m_clothDisplayCache = HK_NULL. This is used for deciding on
        // whether we should toggle non-cloth related meshes in an asset (see PreviewAssetManager::addClothObjects() and
        // PreviewPluginClothImpl::toggleNonClothMeshes()).
        hkgClothDisplayCache* m_clothDisplayCache;
        hkgClothStorageMeshConverter* m_clothStorageMeshConverter;
        hkgClothSetupMeshChannelViewer* m_clothSetupMeshChannelViewer;

        // note this can be more than in the hkx as the loading might generate some
        hkArray<hkdBreakableBody*> m_breakableBodies;
        hkArray<hkpFirstPersonGun*> m_guns;

#ifdef HK_ENABLE_PHYSICS
        hkArray<hknpFirstPersonGun*> m_npGuns;
#endif

#ifdef HK_ENABLE_DESTRUCTION
        hkArray<hkgBreakableEntity*> m_breakableObjects;
        hkArray<hkgDebrisEntity*> m_templateObjects;
#endif

        bool m_shaderSupport;

        hkStringOld m_filename; // may be empty
        hkArray<char> m_rewindPoint; // may be empty
    };


    // Assumed to function in a drag'n'drop style env where
    // assets are added one after the other, not as a batch
    // Or where there is one asset or source (filter pipeline) that
    // you want to experiment with different assets (animations etc)
    class PreviewAssetManager : public hkReferencedObject
    {
    public:

        PreviewAssetManager();
        virtual ~PreviewAssetManager();

        void addAsset(PreviewAsset* asset, bool allowInstances); // it will not enable (add to world etc) too, so you need to explicitly call addAsset on it
        void disableAsset(PreviewAsset* asset); // disable a given asset (remove from world / step) but does not deref
        void enableAsset(PreviewAsset* asset); // enable a given asset (add to world / step)
        void removeAsset(PreviewAsset* asset); // remove (and disable) the asset. Will no longer reference it.
        bool isEnabled(PreviewAsset* asset);

        hkArray<PreviewAsset*> m_allAssets; // referenced
        hkArray<PreviewAsset*> m_enabledAssets; // what the contents of the world etc are currently made up of

        // Graphics
        hkStringOld m_shaderLibDir;
        hkgDisplayWorld* m_displayWorld; // not referenced
        hkgDisplayContext* m_displayContext; // not referenced
        hkgDisplayHandler* m_displayHandler; // not referenced

        hkgDisplayHandler* m_ghostDisplayHandler; // add stuff to this to act as ghosts (usually physics objects etc). Owned.
        hkgDisplayHandler* m_npGhostDisplayHandler; // add stuff to this to act as ghosts (usually physics objects etc). Owned.
        bool m_ghostsEnabled;
        bool m_hideRbMeshes;
        bool m_hideBbMeshes;

        // Multithreading
        hkJobQueue* m_jobQueue;
        hkDefaultTaskQueue* m_taskQueue;

        // Physics
#ifdef HK_ENABLE_PHYSICS_2012
        hkpWorld* m_currentWorld; // owned, first asset that loaded creates the world (if its cinfo if it has one).
#endif
#ifdef HK_ENABLE_PHYSICS
        hknpWorld* m_currentNpWorld; // owned, first asset that loaded creates the world (if its cinfo if it has one).
        hkArray<hknpPhysicsSystem*> m_npSystems;
        hknpProcessContext** m_npVdbContext;
#endif
        hkVector4 m_loadedGravity;
        hkVector4 m_desiredGravity;

#ifdef HK_ENABLE_PHYSICS_2012
        hkpPhysicsContext* m_ghostPhysicsContext;
#endif
        hkRefPtr<hkServerObjectSerializer> m_vdbObjectSerializer;

#ifdef HK_ENABLE_PHYSICS
        hknpProcessContext* m_ghostNewPhysicsContext;
        hknpMultiThreadedShapeViewer* m_npShapeViewer;
        hknpDefaultViewerColorScheme* m_colorScheme;
        hknpDefaultViewerColorScheme* m_vdbColorScheme;
#endif
        hkArray< hkProcess* > m_ghostProcesses;

        // Destruction
#ifdef HK_ENABLE_DESTRUCTION_2012
        hkdWorld* m_destructionWorld;
        hkdDecalMapRuntime* m_decalMapRuntime;

        hkdGraphicsSystem* m_graphicsSystem;
        hkdMeshShapeRegistry* m_meshRegistry;
        hkdMouseSpringReattachUtil* m_mouseSpringReattachUtil;
        hkdDeformableSkinningUtil* m_skinningUtil;
        hkdBreakableBodyListener* m_hideBbMeshesListener;
        hkArray<class hkdBreakableBodyResetUtil*> m_resetUtils;
        hkArray<class hkpRigidBodyResetUtil*> m_rbResetUtils;
        hkArray<class hkdExplodedViewUtil*> m_explodedViewUtils;

        hkdDestructionDemoConfig* m_demoConfig;
#endif

#if defined(HK_ENABLE_DESTRUCTION_2012) || defined(HK_ENABLE_DESTRUCTION)
        hkgMeshSystem* m_meshSystem;
#endif
        hkArray<hkStringOld*> m_texPaths;

        // New Destruction
#ifdef HK_ENABLE_DESTRUCTION
        hkndWorld* m_ndWorld;
        hkndMeshShapeRegistry* m_ndMeshRegistry;
        hkngGraphicsSystem* m_ndGraphicsSystem;
        hkndAssetManager* m_ndAssetMgr;
        hkndDestructionDemoConfig* m_ndDemoCfg;
        hkndProcessContext* m_ndLocalViewersContext;
        hkndFracturePieceNameViewer* m_ndShapeViewer;
        hkArray<hkReferencedObject*> m_ndExtensions;
        hkArray<hkndExplodedViewUtil*> m_ndExplodeUtils;
        hkReferencedObject* m_ndStepper;
        hkBool m_attachToNearbyObjects;
        hkScopedPtr<hkDisableError> m_disableReviewAlertDynamicFracture;
        hkScopedPtr<hkDisableError> m_disableReviewAlertImageBasedFracture;
        hkScopedPtr<hkDisableError> m_disableReviewAlertDeformation;
        hkScopedPtr<hkDisableError> m_disableReviewAlertIntegrityAnalyzer;
        hkScopedPtr<hkDisableError> m_disableReviewAlertDecorateFractureFaces;
        hkScopedPtr<hkDisableError> m_disableReviewAlertDecals;
#endif

        // Animation
        hkArray<hkaAnimationControl*> m_animControls; // one per binding (of which one per anim)
        hkArray<hkaAnimatedSkeleton*> m_animSkeletons; // one per skeleton. All current skeletons that match a loaded anim will have that anim control added for now. When the skel asset is removed, this animskel is deleted
        hkArray<hkUint32> m_animSkeletonColor;
        hkArray<hkQsTransform> m_accumulatedMotions; // an accum motion per anim skel
        hkArray<hkaAnimatedSkeleton*> m_lastAddedAssetSkeletons;
        hkArray<const hkaAnimationBinding*> m_unusedBindings; // keep bindings that are not applied for skels that might be added later


        // Cloth
        hclWorld* m_currentClothWorld;
        hkgClothPicking* m_clothPickingUtil;
        const hclClothContainer* findPreviewClothContainer(hkRootLevelContainer* container);

        bool m_worldCollidablesActive;
        hkArray< const hclCollidable* > m_clothWorldCollidables;
        hclClothContext* m_clothVdbContext;

#ifdef HK_ENABLE_PHYSICS_2012
        hclPhysics2012ClothWorld* m_currentPhysics2012ClothWorld;
#endif

#ifdef HK_ENABLE_PHYSICS
        hclPhysicsClothWorld* m_currentPhysicsClothWorld;
#endif


        // Anim/Cloth
        struct ClothInstanceData
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_TOOLS, ClothInstanceData);

            ClothInstanceData () { }
            ClothInstanceData ( const ClothInstanceData& otherCD )
            {
                m_clothInstance = otherCD.m_clothInstance;
                m_setupObject = otherCD.m_setupObject;
                m_transformSets.insertAt(0, otherCD.m_transformSets.begin(), otherCD.m_transformSets.getSize());
                m_sourceAnimatedSkeletons.insertAt(0, otherCD.m_sourceAnimatedSkeletons.begin(), otherCD.m_sourceAnimatedSkeletons.getSize());
                m_currentState = -1;
            }

            hclClothInstance* m_clothInstance;
            hclClothSetupObject* m_setupObject;
            hkArray< hclTransformSet* > m_transformSets;
            hkArray< hkaAnimatedSkeleton* > m_sourceAnimatedSkeletons;
            int m_currentState;
        };

        hkArray< ClothInstanceData > m_clothInstanceData; // Per Cloth Data

        struct SkeletonMeshBoneDeformData
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_TOOLS, SkeletonMeshBoneDeformData);
            SkeletonMeshBoneDeformData() :m_currentPose(HK_NULL) { }
            SkeletonMeshBoneDeformData(const SkeletonMeshBoneDeformData& otherData)
            {
                m_meshBindingIndices = otherData.m_meshBindingIndices;
                m_meshDeformedDisplayObjects = otherData.m_meshDeformedDisplayObjects;
                m_asset = otherData.m_asset;
                m_deformedSkeleton = otherData.m_deformedSkeleton;
                m_deformingClothData = otherData.m_deformingClothData;
            }

            hkArray<int> m_meshBindingIndices;
            hkArray<hkgDisplayObject*> m_meshDeformedDisplayObjects;

            PreviewAsset* m_asset;
            hkaAnimatedSkeleton* m_deformedSkeleton;
            hkaPose* m_currentPose;

            struct DeformingClothData
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_TOOLS, DeformingClothData);
                DeformingClothData() { }
                DeformingClothData(const DeformingClothData& otherData)
                {
                    m_deformedBoneIndices = otherData.m_deformedBoneIndices;
                    m_meshBoneDeformStates = otherData.m_meshBoneDeformStates;
                    m_clothInstanceData = otherData.m_clothInstanceData;
                    m_transformSetIdx = otherData.m_transformSetIdx;
                }
                hkArray<hkUint16> m_deformedBoneIndices;
                hkArray<hkUint32> m_meshBoneDeformStates;
                ClothInstanceData m_clothInstanceData;
                int m_transformSetIdx;
            };
            hkArray<DeformingClothData> m_deformingClothData;
        };

        // Data associated with skeletons that are deformed by Cloth's mesh-bone deform operator
        hkArray<SkeletonMeshBoneDeformData > m_deformedSkeletonMeshes;

        // Complete (Phys+Anim)
        enum RagdollMappingDirection
        {
            NO_RAGDOLL_MAPPING,
            RAGDOLL_TO_ANIM_MAPPING,
            ANIM_TO_RAGDOLL_MAPPING
        };
        RagdollMappingDirection m_ragdollMappingType;

        hkArray< class hkaSkeletonMapper* > m_skeletonMappers;
#ifdef HK_ENABLE_PHYSICS_2012
        hkArray< hkaRagdollInstance* > m_2012ragdolls;
#endif
#ifdef HK_ENABLE_PHYSICS
        hkArray< hknpRagdoll* >m_npRagdolls;
#endif
        struct DropTarget
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_TOOLS, DropTarget);

            hkStringOld m_name;
            hkAabb m_bounds;

            void drawTriangles(class hkgDisplayContext* ctx);
        };

        void getDropTargets( hkArray< DropTarget >& targets );

    public:

        const hkaSkeletonMapper* findMapperFromSkeleton (const hkaSkeleton* skeletonA) const;



        // Display
        bool createSceneConverter(PreviewAsset* asset, hkUint32& convMask);
        void addGraphicsObjects(PreviewAsset* asset, hkgDefaultSceneDataFilter* filter, bool shouldConvert, bool shouldAdd, hkUint32 convMask);
        void removeGraphicsObjects(PreviewAsset* asset);
        void toggleRbDisplay(bool on);
        void toggleBbDisplay(bool displayMeshes);
        void toggleGhostTransparency( bool transparent );
        void setupSkyBox(const char* skyBoxFileName);

        // Phys
        void addPhysicsObjects(PreviewAsset* asset);
        void removePhysicsObjects(PreviewAsset* asset);
        void deleteRbResetUtils();
        void deletePhysicsWorld();

        // New Phys
        void addNewPhysicsObjects(PreviewAsset* asset);
        void addPhysicsSystemGraphics(hkxScene* scene, PreviewAsset* asset, hknpPhysicsSystem* syst);
        void postProcessPhysicsDisplay();
        void removeNewPhysicsObjects(PreviewAsset* asset);
        void deleteNewPhysicsWorld();
        void onBodyBufferFullSignal(hknpWorld* npWorld, hknpBodyManager* npBodyManager);
        void onMotionBufferFullSignal(hknpWorld* npWorld, hknpMotionManager* npMotionManager);
        void onConstraintBufferFullSignal(hknpWorld* npWorld, hknpConstraintManager* npConstraintManager);
        void onBodyExitedBroadPhase( const hknpEventHandlerInput& input, const hknpEvent& event );
        void onConstraintForceExceeded( const hknpEventHandlerInput& input, const hknpEvent& event );

        // New Destruction
        void addNewDestructionObjects(PreviewAsset* asset);
        void removeNewDestructionObjects(PreviewAsset* asset);
        void deleteNewDestructionWorld();
        bool configureNdSceneConverter(PreviewAsset* asset);
        void toggleNdBodiesDisplay();
        void resetNdScene();
        void toggleNdExplodedState(bool explodeOn);
        void toggleNdShapeNamesDisplay(bool namesOn);
        hkgDisplayObject* createBullet(PreviewAsset* asset, hkReal radius, const char* materialName);

    private:

        void _setAndAddAnimationControl( hkaAnimatedSkeleton* skeleton, const hkaAnimationBinding* binding );

    public:

        // Anim
        void addAnimationObjects(PreviewAsset* asset);
        void removeAnimationObjects(PreviewAsset* asset);
        void findAttachments(PreviewAsset* asset);

        // Phys+Anim (ragdolls). Returns true if it did it.
        bool addCompleteObjects(PreviewAsset* asset);
        bool removeCompleteObjects(PreviewAsset* asset);
        void updateRagdollMappingType();
        void findAttachmentsWithoutRagdolls(PreviewAsset* asset);
        // Physics 2012 and new physics + animation implementation
#ifdef HK_ENABLE_PHYSICS_2012
        // Returns the number of created ragdolls
        int addCompletePhysics2012Objects(PreviewAsset* asset);
        void removeCompletePhysics2012Objects(PreviewAsset* asset);
        void update2012RagdollMapping( const hkaSkeleton* ragdollSkel );
        bool is2012RagdollSkeleton( const hkaSkeleton* skeleton );
        void step2012Ragdoll( const hkaSkeleton* animSkeleton, const hkaSkeleton* ragdollSkeleton, const hkQsTransform& worldFromModel, hkaPose& animationPose  ) const;
#else
        int addCompletePhysics2012Objects(PreviewAsset* asset) { return 0;}
        void update2012RagdollMapping( const hkaSkeleton* ragdollSkel) {}
        void removeCompletePhysics2012Objects(PreviewAsset* asset){}
        bool is2012RagdollSkeleton( const hkaSkeleton* skeleton ) {return false;}
        void step2012Ragdoll(const hkaSkeleton* animSkeleton, const hkaSkeleton* ragdollSkeleton, const hkQsTransform& worldFromModel, hkaPose& animationPose ) const {}
#endif

#ifdef HK_ENABLE_PHYSICS
        int addCompleteNpObjects(PreviewAsset* asset);
        void removeCompleteNpObjects(PreviewAsset* asset);
        void updateNpRagdollMapping( const hkaSkeleton* ragdollSkel );
        bool isNpRagdollSkeleton( const hkaSkeleton* skeleton );
        void stepNpRagdoll( const hkaSkeleton* animSkeleton, const hkaSkeleton* ragdollSkeleton, const hkQsTransform& worldFromModel, hkaPose& animationPose  ) const;
#else
        int addCompleteNpObjects(PreviewAsset* asset) { return 0;}
        void removeCompleteNpObjects(PreviewAsset* asset){}
        void updateNpRagdollMapping( const hkaSkeleton* ragdollSkel) {}
        bool isNpRagdollSkeleton( const hkaSkeleton* skeleton ) {return false;}
        void stepNpRagdoll(const hkaSkeleton* animSkeleton, const hkaSkeleton* ragdollSkeleton, const hkQsTransform& worldFromModel, hkaPose& animationPose ) const {}
#endif

        // Cloth
        void setupClothNodeFilter( PreviewAsset* asset, hkgDefaultSceneDataFilter** filter );
        void addClothObjects(PreviewAsset* asset, hkgDefaultSceneDataFilter* filter);
        void setupMeshBoneDeformMeshes(PreviewAsset* asset, int startIndex, int numClothInstanceData);
        void removeClothObjects(PreviewAsset* asset);
        void deleteClothWorld();
        void disableClothWorldCollidables();
        void enableClothWorldCollidables();

#ifdef HK_ENABLE_PHYSICS_2012
        void enableClothRigidBodyCollidables();
        void disableClothRigidBodyCollidables();
#else
        void enableClothRigidBodyCollidables(){}
        void disableClothRigidBodyCollidables(){}
#endif

#ifdef HK_ENABLE_PHYSICS
        void enableClothBodyCollidables();
        void disableClothBodyCollidables();
#else
        void enableClothBodyCollidables(){}
        void disableClothBodyCollidables(){}
#endif

        // Destruction
        void addDestructionObjects(PreviewAsset* asset);
        void removeDestructionObjects(PreviewAsset* asset);
        void deleteDestructionWorld();
        void configureDestruction(PreviewAsset* asset);
        void addFloor(PreviewAsset* asset);
        void loadSkybox(PreviewAsset* asset, const char* n);
        void addSkyBox(PreviewAsset* asset, const hkStringOld& skyboxPath);
        void toggleDestructionBodiesDisplay();

        hkgDisplayObject* createBallGunBulletGraphicsInstance(hkpRigidBody* rb, hkgDisplayObject* dspShape);
        hkgDisplayObject* deleteBallGunBulletGraphicsInstance(hkpRigidBody* rb);

    };

} // namespace

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
