// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/Thread/TaskQueue/Default/hkDefaultTaskQueue.h>

#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

// Register classes
#include <Common/Base/KeyCode.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileWriteFormat.h>

//
// USING* defines come from the keycode for the SDK we are using
// ENABLE* defines come from this Preview config, which should match it. The ENABLE* are used throughout the Preview to allow easy configs against the same SDK (mainly for dev testing)
//
#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012) && defined(HK_ENABLE_PHYSICS_2012)
#   define HK_FEATURE_REFLECTION_PHYSICS_2012
#endif
#if defined(HK_FEATURE_PRODUCT_PHYSICS) && defined(HK_ENABLE_PHYSICS)
#   define HK_FEATURE_REFLECTION_PHYSICS
#endif
#if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012) && defined(HK_ENABLE_DESTRUCTION_2012)
#   define HK_FEATURE_REFLECTION_DESTRUCTION_2012
#endif
#if defined(HK_FEATURE_PRODUCT_DESTRUCTION) && defined(HK_ENABLE_DESTRUCTION)
#   define HK_FEATURE_REFLECTION_DESTRUCTION
#endif
#if defined(HK_FEATURE_PRODUCT_ANIMATION) && defined(HK_ENABLE_ANIMATION)
#   define HK_FEATURE_REFLECTION_ANIMATION
#endif
#if defined(HK_FEATURE_PRODUCT_CLOTH) && defined(HK_ENABLE_CLOTH_PREVIEW )
#   define HK_FEATURE_REFLECTION_CLOTH
#   define HK_FEATURE_REFLECTION_CLOTH_SETUP
#   if defined(HK_FEATURE_PRODUCT_ANIMATION) && defined(HK_ENABLE_ANIMATION)
#       define HK_FEATURE_REFLECTION_CLOTH_SETUP_ANIMATION
#   endif
#endif


//COMPAT_REG_ALL

#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>

#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/hkgSystemFunctions.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <Plugins/Preview/hctPreviewAsset.h>


#pragma managed
using namespace PreviewPlugin;
using namespace System::Windows;
using namespace System::Windows::Forms;

void FindShaderLibDir( hkStringOld& dir );

static void _displayErrorMessage( const char* err)
{
    MessageBox::Show( gcnew System::String(err), "Havok Preview Asset", MessageBoxButtons::OK, MessageBoxIcon::Error );
}

#pragma unmanaged

PreviewAsset::PreviewAsset()
: m_container(HK_NULL), m_rootMem(HK_NULL), m_convertedGraphicsObjects(HK_NULL), m_animFootstepAnalysisInfo(HK_NULL), m_animPreviewColor(HK_NULL), m_collidablesSkel(HK_NULL), m_animationToClothCollidablesMapper(HK_NULL), m_clothDisplayCache(HK_NULL), m_clothStorageMeshConverter(HK_NULL), m_clothSetupMeshChannelViewer(HK_NULL)
,   m_shaderSupport(false)
{
    m_filename = "";
}

PreviewAsset::~PreviewAsset()
{
    clear();
}

void PreviewAsset::clear()
{
    if (m_convertedGraphicsObjects)
    {
        m_convertedGraphicsObjects->removeCreatedObjectsFromWorld();
        m_convertedGraphicsObjects->removeReference();
    }

    m_collidablesPose.setSize(0);
    m_attachmentObjects.setSize(0);

    if (m_clothDisplayCache)
    {
        ((hkReferencedObject*)m_clothDisplayCache)->removeReference();
    }

    if (m_clothStorageMeshConverter)
    {
        ((hkReferencedObject*)m_clothStorageMeshConverter)->removeReference();
    }

    if (m_clothSetupMeshChannelViewer)
    {
        ((hkReferencedObject*)m_clothSetupMeshChannelViewer)->removeReference();
    }

    if (m_rootMem)
    {
        // will delete the scene container etc
        m_rootMem->removeReference();
    }


    m_animPreviewColor = HK_NULL;
    m_animFootstepAnalysisInfo = HK_NULL;
    m_collidablesSkel = HK_NULL;
    m_animationToClothCollidablesMapper = HK_NULL;
    m_convertedGraphicsObjects = HK_NULL;
    m_clothDisplayCache = HK_NULL;
    m_clothStorageMeshConverter = HK_NULL;
    m_container = HK_NULL; // either in mem (owned by someone else) or allocd in the rootmem anyway
    m_rootMem = HK_NULL;
    m_filename = "";
}

void PreviewAsset::loadFromStream( hkStreamReader* r )
{
    if (m_container)
    {
        clear();
    }

    hkSerializeUtil::ErrorDetails err;
    m_rootMem = hkSerializeUtil::loadOnHeap(r, &err);
    if(! m_rootMem )
    {
        HK_WARN_ALWAYS(0xabbab5e5, err.defaultMessage.cString() );
        _displayErrorMessage( err.defaultMessage.cString() );
        return;
    }
    m_container = m_rootMem->getContents<hkRootLevelContainer>();
    if( !m_container )
    {
        HK_WARN_ALWAYS(0xabba1730, "No root level container in the file. Is it a user created file? Can not load without the hkRootLevelContainer at the top level.");
    }
}

void PreviewAsset::loadFromFile( const char* fullPath )
{
    hkIstream is(fullPath);
    HK_ASSERTV( 0x215d080c, is.isOk(), "Could not open '{}' for reading.", fullPath );
    if (is.isOk())
    {
        loadFromStream( is.getStreamReader() );

        m_filename = fullPath;
    }
}

hkResult PreviewAsset::makeRewindPoint(void* reg)
{

    m_rewindPoint.reserve(4096);
    m_rewindPoint.setSize(0);

    hkOstream memStream( m_rewindPoint );
    if ( memStream.isOk() )
    {
        hkSerialize::TagfileWriteFormat wf;
        return hkSerialize::Save().contentsPtr(m_container, memStream.getStreamWriter());
    }

    return HK_FAILURE;
}

const char* PreviewAsset::getName()
{
    if (m_container)
    {
        hkxScene* scene = m_container->findObject<hkxScene>();
        if (scene)
        {
            return scene->m_asset;
        }
    }
    return HK_NULL;
}

PreviewAsset::ModellerType PreviewAsset::getModeller() const
{
    if (m_container)
    {
        hkxScene* scene = m_container->findObject<hkxScene>();
        if (scene && scene->m_modeller)
        {
            hkStringOld modeller( hkStringOld(scene->m_modeller).asLowerCase() );

            if( modeller.beginsWith( "maya" ) )
            {
                return MODELLER_MAYA;
            }
            else if ( modeller.beginsWith( "3ds" ) )
            {
                return MODELLER_3DS_MAX;
            }
            else if ( modeller.beginsWith( "xsi" ) )
            {
                return MODELLER_XSI;
            }
        }
    }

    return MODELLER_INVALID;
}

//
// Manager

PreviewAssetManager::PreviewAssetManager()
:   m_displayWorld(HK_NULL)
,   m_displayContext(HK_NULL)
,   m_displayHandler(HK_NULL)
,   m_ghostDisplayHandler(HK_NULL)
,   m_npGhostDisplayHandler(HK_NULL)
,   m_ghostsEnabled(false)
,   m_hideRbMeshes(false)
,   m_hideBbMeshes(false)
,   m_jobQueue(HK_NULL)
#ifdef HK_ENABLE_PHYSICS_2012
,   m_currentWorld(HK_NULL)
,   m_ghostPhysicsContext(HK_NULL)
#endif
#ifdef HK_ENABLE_PHYSICS
,   m_currentNpWorld(HK_NULL)
,   m_ghostNewPhysicsContext(HK_NULL)
,   m_npShapeViewer(HK_NULL)
,   m_colorScheme(HK_NULL)
,   m_vdbColorScheme(HK_NULL)
,   m_npVdbContext(HK_NULL)
#endif
#if defined(HK_ENABLE_DESTRUCTION_2012) || defined(HK_ENABLE_DESTRUCTION)
,   m_meshSystem(HK_NULL)
#endif
#ifdef HK_ENABLE_DESTRUCTION
,   m_ndWorld(HK_NULL)
,   m_ndMeshRegistry(HK_NULL)
,   m_ndGraphicsSystem(HK_NULL)
,   m_ndAssetMgr(HK_NULL)
,   m_ndDemoCfg(HK_NULL)
,   m_ndLocalViewersContext(HK_NULL)
,   m_ndShapeViewer(HK_NULL)
,   m_ndStepper(HK_NULL)
,   m_attachToNearbyObjects(false)
#endif
#if defined(HK_ENABLE_PHYSICS_2012) && defined(HK_ENABLE_CLOTH_PREVIEW )
,   m_currentPhysics2012ClothWorld(HK_NULL)
#endif
#if defined(HK_ENABLE_PHYSICS) && defined(HK_ENABLE_CLOTH_PREVIEW )
,   m_currentPhysicsClothWorld(HK_NULL)
#endif
,   m_currentClothWorld(HK_NULL)
,   m_worldCollidablesActive(false)
,   m_clothPickingUtil(HK_NULL)
,   m_clothVdbContext(HK_NULL)
{
    FindShaderLibDir( m_shaderLibDir );

    // Destruction
#ifdef HK_ENABLE_DESTRUCTION_2012
    m_destructionWorld = HK_NULL;
    m_decalMapRuntime = HK_NULL;
    m_graphicsSystem = HK_NULL;
    m_meshRegistry = HK_NULL;
    m_mouseSpringReattachUtil = HK_NULL;
    m_skinningUtil = HK_NULL;
    m_hideBbMeshesListener = HK_NULL;
    m_demoConfig = HK_NULL;
#endif

    m_loadedGravity.set(0,-9.81f,0);
    m_desiredGravity.set(0,-9.81f,0);

    // Creates the task queue
    m_taskQueue = new hkDefaultTaskQueue();

    m_vdbObjectSerializer = hkRefNew<hkServerObjectSerializer>(new hkServerObjectSerializer(HK_NULL, HK_NULL));

    // Force denormals numbers to be flushed to zero (EXP-2686)
    _MM_SET_FLUSH_ZERO_MODE(_MM_FLUSH_ZERO_ON);

}


PreviewAssetManager::~PreviewAssetManager()
{
    deleteRbResetUtils();

    deleteClothWorld();
    deleteDestructionWorld();
    deletePhysicsWorld();

    for (int ai=m_allAssets.getSize()-1; ai >=0; --ai)
    {
        removeAsset( m_allAssets[ai] );
    }

    m_taskQueue->close();   
    delete m_taskQueue;
    m_taskQueue = HK_NULL;

    deleteNewDestructionWorld();
    deleteNewPhysicsWorld();

    for (int i=0; i<m_texPaths.getSize(); ++i)
    {
        delete m_texPaths[i];
    }
}


void PreviewAssetManager::addAsset(PreviewAsset* asset, bool allowInstances)
{
    if (m_allAssets.indexOf(asset) < 0)
    {
        if (asset && asset->m_container)
        {
            // For now, if asset has same name as existing asset it will replace it:
            const char* assetName = asset->getName();
            if (!allowInstances)
            {
                for (int ai=m_allAssets.getSize()-1; assetName && (ai >= 0); --ai)
                {
                    const char* existingName = m_allAssets[ai]->getName();
                    if (existingName && (hkString::strCasecmp(existingName, assetName) == 0) )
                    {
                        removeAsset(m_allAssets[ai]);
                    }
                }
            }

            m_allAssets.pushBack(asset);
            asset->addReference();
        }
        // else it is empty
    }
    // else have it already.. allow > 1 add? (prob yes: 10 boxes etc).
}

void PreviewAssetManager::removeAsset(PreviewAsset* asset)
{
    int idx = m_allAssets.indexOf(asset);
    if (idx >= 0) // have it
    {
        if (m_enabledAssets.indexOf(asset) >= 0) // enabled?
        {
            disableAsset(asset);
        }

        m_allAssets.removeAtAndCopy(idx);
        asset->removeReference();
    }
}


bool PreviewAssetManager::isEnabled(PreviewAsset* asset)
{
    return (m_enabledAssets.indexOf(asset) >= 0);
}

void PreviewAssetManager::enableAsset(PreviewAsset* asset)
{
    if (m_allAssets.indexOf(asset) >= 0)
    {
        if (m_enabledAssets.indexOf(asset) < 0)
        {
            m_enabledAssets.pushBack(asset);

            hkgDefaultSceneDataFilter* filter = HK_NULL;

            // Cloth requires some special node filtering
            // to avoid mesh sharing etc
            setupClothNodeFilter( asset, &filter );


            // Graphics:
            hkUint32 convMask           = hkgAssetConverter::CONVERT_ALL;
            const bool shouldConvert    = createSceneConverter(asset, convMask);

            // Give other products a chance to configure the scene converter
            const bool shouldAdd        = configureNdSceneConverter(asset);

            // Convert and potentially add objects to the graphics world
            addGraphicsObjects(asset, filter, shouldConvert, shouldAdd, convMask);

            // Havok Complete (Anim+Phys)
            if (!addCompleteObjects(asset))
            {
                // Physics:
                addPhysicsObjects( asset );

                // New Physics
                addNewPhysicsObjects( asset );

                // Animation:
                addAnimationObjects( asset );
            }


            //Cloth
            addClothObjects( asset, filter );

            // Destruction
            addDestructionObjects( asset );

            // New Destruction6
            addNewDestructionObjects(asset);

            // Potentially remove any rigid body messhes added by addGraphicsObjects()
            toggleRbDisplay(!m_hideRbMeshes);

            if (filter)
            {
                delete filter;
            }

        }// is not enabled
    }// have asset
    // else not in manager
}


void PreviewAssetManager::disableAsset(PreviewAsset* asset)
{
    int idx = m_enabledAssets.indexOf(asset);
    if (idx >= 0)
    {
        m_enabledAssets.removeAtAndCopy(idx);

        hkRootLevelContainer* root = asset->m_container;
        if (!root) return; // should not happen, but just to be safe

        // Graphics:
        removeGraphicsObjects( asset );

        // Destruction
        removeDestructionObjects( asset );

        // New Destruction
        removeNewDestructionObjects(asset);

        // Havok Complete (Anim+Phys)
        if (!removeCompleteObjects(asset))
        {
            // Physics:
            removePhysicsObjects( asset );

            // New Physics:
            removeNewPhysicsObjects( asset );

            // Animation:
            removeAnimationObjects( asset );
        }


        //Cloth
        removeClothObjects( asset );

    }
    // else not enabled at the mo anyway
}

void PreviewAssetManager::getDropTargets( hkArray< DropTarget >& targets )
{
    for (int ai=0; ai < m_enabledAssets.getSize(); ++ai)
    {
        //XX add skeletons etc as drop targets

        // for now, just outline the display objects to test etc
        if (m_enabledAssets[ai]->m_convertedGraphicsObjects)
        {
            hkgSceneDataConverter* assetConv = m_enabledAssets[ai]->m_convertedGraphicsObjects;
            int numMeshes = assetConv->m_meshes.getSize();
            for (int mi=0; mi < numMeshes; ++mi)
            {
                hkgDisplayObject* obj = (hkgDisplayObject*)( assetConv->m_meshes[mi].m_hkgObject );
                if (obj)
                {
                    hkgAabb aabb;
                    obj->computeAABB();
                    obj->getAABB(aabb.m_min, aabb.m_max);
                    PreviewAssetManager::DropTarget& dt = targets.expandOne();
                    dt.m_name = obj->m_name;
                    float ext[3]; hkgVec3Sub( ext, aabb.m_max, aabb.m_min );
                    hkgVec3Scale(ext, 0.1f );
                    dt.m_bounds.m_min.set( aabb.m_min[0]-ext[0], aabb.m_min[1]-ext[1], aabb.m_min[2]-ext[2] );
                    dt.m_bounds.m_max.set( aabb.m_max[0]+ext[0], aabb.m_max[1]+ext[1], aabb.m_max[2]+ext[2] );
                }
            }
        }
    }
}



void PreviewAssetManager::DropTarget::drawTriangles(hkgDisplayContext* ctx)
{
    static int triList[] = { 0, 1, 2, 7, 5, 4, 3, 6, 0, 1, 1, 6, 7, 4, 4, 5, 5, 3, 2, 0 };
    hkVector4 verts[8];
    verts[0] = m_bounds.m_min;
    verts[1] = m_bounds.m_min; verts[1](0) = m_bounds.m_max(0);
    verts[2] = m_bounds.m_min; verts[2](1) = m_bounds.m_max(1);
    verts[3] = m_bounds.m_min; verts[3](2) = m_bounds.m_max(2);
    verts[4] = m_bounds.m_max;
    verts[5] = m_bounds.m_max; verts[5](0) = m_bounds.m_min(0);
    verts[6] = m_bounds.m_max; verts[6](1) = m_bounds.m_min(1);
    verts[7] = m_bounds.m_max; verts[7](2) = m_bounds.m_min(2);

    const float solidcolor[] = { 0.1f, 0.3f, 0.1f, 0.4f };
    ctx->setCurrentColor4(solidcolor);
    ctx->beginGroup(HKG_IMM_TRIANGLE_STRIP);
        const int numVerts = sizeof(triList) / sizeof(int);
        for (int vi=0; vi < numVerts; ++vi)
        {
            ctx->setCurrentPosition( (float*)&verts[ triList[vi] ] );
        }
    ctx->endGroup();

    const float wirecolor[] = { 0.3f, 0.9f, 0.3f, 0.8f };
    ctx->setCurrentColor4(wirecolor);
    ctx->beginGroup(HKG_IMM_LINES);
    {
        ctx->setCurrentPosition( (float*)&verts[0] ); ctx->setCurrentPosition( (float*)&verts[1] );
        ctx->setCurrentPosition( (float*)&verts[1] ); ctx->setCurrentPosition( (float*)&verts[7] );
        ctx->setCurrentPosition( (float*)&verts[7] ); ctx->setCurrentPosition( (float*)&verts[2] );
        ctx->setCurrentPosition( (float*)&verts[2] ); ctx->setCurrentPosition( (float*)&verts[0] );

        ctx->setCurrentPosition( (float*)&verts[3] ); ctx->setCurrentPosition( (float*)&verts[6] );
        ctx->setCurrentPosition( (float*)&verts[6] ); ctx->setCurrentPosition( (float*)&verts[4] );
        ctx->setCurrentPosition( (float*)&verts[4] ); ctx->setCurrentPosition( (float*)&verts[5] );
        ctx->setCurrentPosition( (float*)&verts[5] ); ctx->setCurrentPosition( (float*)&verts[3] );

        ctx->setCurrentPosition( (float*)&verts[0] ); ctx->setCurrentPosition( (float*)&verts[3] );
        ctx->setCurrentPosition( (float*)&verts[1] ); ctx->setCurrentPosition( (float*)&verts[6] );
        ctx->setCurrentPosition( (float*)&verts[7] ); ctx->setCurrentPosition( (float*)&verts[4] );
        ctx->setCurrentPosition( (float*)&verts[2] ); ctx->setCurrentPosition( (float*)&verts[5] );
    }
    ctx->endGroup();

    ctx->setCurrentPosition( (float*)&verts[ triList[0] ] );
    ctx->endGroup();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
