
@ECHO OFF

REM %1 == The name of the project that called the custom build step
REM %2 == HAVOK_TOOLS_ROOT (taken from environment variable)
REM %3 == TARGET_PATH (full path to DLL)
REM %4 == TargetPlatform (win32, x64)

if "%~2" == "" goto nodeploy

REM Save re-execution details in redeploy.bat
set REDEPLOY_FILE=%~dp0redeploy_%~n1.bat
if exist %REDEPLOY_FILE% del %REDEPLOY_FILE%
echo %~dpnx0 %* > %REDEPLOY_FILE%

setlocal
mkdir "%~2\tools" > nul
mkdir "%~2\tools\shaderlib" > nul
mkdir "%~2\tools\shaderlib\posteffects" > nul
mkdir "%~2\tools\shaderlib\textures" > nul

xcopy "%~3" "%~2\tools" /s /y /r >nul
xcopy ..\..\..\..\..\..\Demo\Demos\Resources\Common\ShaderLib "%~2\tools\shaderlib" /s /y /r >nul
xcopy ..\..\..\..\..\..\Demo\Demos\Resources\Common\Graphics\Effects "%~2\tools\shaderlib\posteffects" /s /y /r >nul
xcopy ..\..\..\..\..\..\Demo\Demos\Resources\Common\Textures "%~2\tools\shaderlib\textures" /s /y /r >nul

REM Copy debug HCT PDBs...
@setlocal enableextensions enabledelayedexpansion
set PDB_SRC_DIR=%~dp3
set PDB_BASENAME=%~n3
set PDB_DEST_DIR="%~2\tools"
FOR %%a IN ("%PDB_SRC_DIR:~0,-1%") DO SET PDB_SRC_DIR_PARENT=%%~dpa

if %PDB_SRC_DIR%==%PDB_SRC_DIR_PARENT%debug\ if exist "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" echo "%PDB_BASENAME%_link.pdb->%PDB_DEST_DIR%"
if %PDB_SRC_DIR%==%PDB_SRC_DIR_PARENT%debug\ if exist "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" xcopy "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" "%PDB_DEST_DIR%" /s /y /r >nul
endlocal
REM Done copying Debug HCT PDBs

if errorlevel 1 goto failure

mkdir "%~2\utils" > nul
xcopy "..\..\..\..\..\..\Tools\FileConvert\CompatFormats\%~4\hkCompatFormats.dll" "%~2\utils" /s /y /r >nul

echo Files copied to %2

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo Files copied to %2 > "%~3.output"

exit /b 0

endlocal 


:nodeploy

echo WARNING: HAVOK_TOOLS_ROOT is not defined. The deployment step has been skipped.

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo WARNING: HAVOK_TOOLS_ROOT is not defined. The deployment step has been skipped. > "%~3.output"
exit /b 0


:failure

echo Couldn't copy all files to %2... 
echo Make sure DLLs are not in use and that HAVOK_TOOLS_ROOT is defined

REM Print an error message for the continuous integration system to detect.
echo ERROR: Custom build step failed.

REM Return an ErrorLevel of 1
exit /b 1

