// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma unmanaged

#include <Plugins/Preview/hctPreviewPlugin.h>
#include <Plugins/Preview/Utilities/hctPreviewSettings.h>


#pragma managed
using namespace Microsoft::Win32;

void hctPreviewSettings::setFolder( String^ folder )
{
    m_folder = folder;

    if( !m_root->EndsWith( "\\") )
    {
        m_folder = "\\" + m_folder;
    }
}


// Registry Settings
void hctPreviewSettings::saveValue( String^ propertyName, System::Object^ propValue )
{
    String^ key = (m_root + m_folder);
    RegistryKey^ subKey = Registry::CurrentUser->CreateSubKey(key, RegistryKeyPermissionCheck::ReadWriteSubTree);
    if ( subKey != nullptr )
    {
        subKey->SetValue(propertyName, propValue);
    }
}

System::Object^ hctPreviewSettings::loadValue( String^ propertyName )
{
    return loadValue( propertyName, nullptr );
}

System::Object^ hctPreviewSettings::loadValue( String^ propertyName, System::Object^ propDefaultValue )
{
    String^ key = (m_root + m_folder);
    RegistryKey^ subKey = Registry::CurrentUser->OpenSubKey(key);
    System::Object^ res = nullptr;
    if (subKey != nullptr)
    {
        res = subKey->GetValue(propertyName, propDefaultValue);
    }

    return (res != nullptr) ? res : propDefaultValue;
}

void hctPreviewSettings::deleteValue( String^ propertyName )
{
    String^ key = ( m_root + m_folder );

    RegistryKey^ rk = Registry::CurrentUser->OpenSubKey( key, true );

    if ( !key->EndsWith("\\") )
    {
        key += "\\";
    }

    if ( rk != nullptr )
    {
        Registry::CurrentUser->DeleteValue( key + propertyName );
    }
}

void hctPreviewSettings::deleteCurrentFolder()
{
    String^ key = ( m_root + m_folder );
    RegistryKey^ rk = Registry::CurrentUser->OpenSubKey( key, true );

    if ( rk != nullptr )
    {
        Registry::CurrentUser->DeleteSubKeyTree( key );
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
