// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>
#include <Plugins/Preview/Physics/hctPreviewPhysics.h>

#include <Graphics/Bridge/hkGraphicsBridge.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

void PreviewPluginPhysicsImpl::tweakGetDataAndClass( const ObjectPickInfo& objectToTweak, void*& dataPtr, const hkReflect::Type*& klassPtr )
{
    dataPtr = HK_NULL;
    klassPtr = HK_NULL;
    if ( objectToTweak.m_object == HK_NULL )
    {
        return;
    }

    const int userPtrType = objectToTweak.m_object->getUserPointerType();
    if ((userPtrType == hkgDisplayObject::USER_POINTER_BREAKABLE_BODY) ||
        (userPtrType == hkgDisplayObject::USER_POINTER_ND_BREAKABLE_BODY))
    {
        return;
    }

    // XX TEST FOR RBS FOR NOW, COULD BE ANYTHING IN FUTURE

    hkUint64 id = m_commonCore->m_displayHandler->getDisplayObjectId(objectToTweak.m_object);

    if (id == 0) //then try the ghost display
    {
        if ( m_commonCore->m_assetManager && m_commonCore->m_assetManager->m_ghostDisplayHandler)
        {
            id = m_commonCore->m_assetManager->m_ghostDisplayHandler->getDisplayObjectId( objectToTweak.m_object  );
        }
    }

    // Check if id is valid
    if ( id != 0  )
    {
        if ((id & 0x3) == 0x3)
            id &= ~0x3;
        else if ((id % 4) != 0)
            return; // no pick (sweep shape display object or something)
    }

    hkpCollidable* cd = (hkpCollidable*)id;
    if( cd && (cd->getOwner()) )
    {
        hkpRigidBody* rb = hkpGetRigidBody(cd);

        dataPtr = rb;
        klassPtr = hkReflect::getType<hkpRigidBody>();
    }
}

void PreviewPluginPhysicsImpl::tweakVerifyClass( const hkReflect::Type* klassPtr )
{

}

void PreviewPluginPhysicsImpl::tweakCommit( void* origData, const hkReflect::Type* origKlass, void* newData )
{
    if ( origKlass == hkReflect::getType<hkpRigidBody>())
    {
        hkpRigidBody* origRb = (hkpRigidBody*)origData;
        m_commonCore->m_assetManager->m_currentWorld->removeEntity(origRb);

        hkpRigidBody* newRb = (hkpRigidBody*)newData;
        m_commonCore->m_assetManager->m_currentWorld->addEntity(newRb);

        origRb->removeReference();
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
