// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Thread/JobQueue/hkJobQueue.h>
#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>

#include <Common/Visualize/hkProcess.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>
#include <Plugins/Preview/Physics/hctPreviewPhysics.h>

#include <Physics2012/Dynamics/World/hkpWorld.h>

void PreviewPluginPhysicsImpl::startPlay()
{
    m_isPhysPlaying  = true;
}

void PreviewPluginPhysicsImpl::stopPlay()
{
    m_isPhysPlaying = false;
}


void PreviewPluginPhysicsImpl::step(float dt)
{
    // Physics
    hkpWorld* world = m_commonCore->m_assetManager->m_currentWorld;
    if (m_isPhysPlaying && world)
    {
        if (!world->getGravity().equals3( m_commonCore->m_assetManager->m_desiredGravity ))
        {
            world->setGravity( m_commonCore->m_assetManager->m_desiredGravity );
        }

        if (HK_PREVIEW_MULTITHREADED_PHYSICS==0)
        {
            world->stepDeltaTime(dt);
        }
        else
        {
            world->stepMultithreaded( m_commonCore->m_jobQueue, m_commonCore->m_threadPool, dt );
        }

        for (int pi=0; pi < m_commonCore->m_assetManager->m_ghostProcesses.getSize(); ++pi)
        {
            m_commonCore->m_assetManager->m_ghostProcesses[pi]->step(dt);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
