// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged
#include <Common/Base/hkBase.h>
#include <Common/Base/KeyCode.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>
#include <Plugins/Preview/Physics/hctPreviewPhysics.h>

#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>

#include <Graphics/Bridge/hkGraphicsBridge.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>


#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Physics2012/Utilities/Actions/MouseSpring/hkpMouseSpringAction.h>

#include <Physics2012/Dynamics/World/hkpSimulationIsland.h>

static hkpRigidBody* _findCollidableInWorld(hkUint64 id, hkpWorld* world)
{
    for( int i = 0; i < world->getActiveSimulationIslands().getSize(); i++ )
    {
        const hkpSimulationIsland* island = world->getActiveSimulationIslands()[i];
        for( int r = 0 ; r < island->getEntities().getSize(); r++ )
        {
            hkpEntity* ent = island->getEntities()[r];
            if( (hkUint64)ent->getCollidable() == id )
            {
                return static_cast<hkpRigidBody*>(ent);
            }
        }
    }

    for( int i = 0; i < world->getInactiveSimulationIslands().getSize(); i++ )
    {
        const hkpSimulationIsland* island = world->getInactiveSimulationIslands()[i];
        for( int r = 0 ; r < island->getEntities().getSize(); r++ )
        {
            hkpEntity* ent = island->getEntities()[r];
            if( (hkUint64)ent->getCollidable() == id )
            {
                return static_cast<hkpRigidBody*>(ent);
            }
        }
    }

    return HK_NULL;
}


bool PreviewPluginPhysicsImpl::ownsDisplayObject( hkgDisplayObject* obj )
{
    if ( !m_commonCore->m_displayHandler )
    {
        return false;
    }

    const int userPtrType = obj->getUserPointerType();
    if ((userPtrType == hkgDisplayObject::USER_POINTER_BREAKABLE_BODY) ||
        (userPtrType == hkgDisplayObject::USER_POINTER_ND_BREAKABLE_BODY) ||
        (userPtrType == USER_TYPE_DISPLAY_OBJECT_NEW_PHYSICS))
    {
        return false;
    }

    hkUint64 collidableId = m_commonCore->m_displayHandler->getDisplayObjectId( obj );

    if (collidableId == 0) //then try the ghost display
    {
        if ( m_commonCore->m_assetManager && m_commonCore->m_assetManager->m_ghostDisplayHandler)
        {
            collidableId = m_commonCore->m_assetManager->m_ghostDisplayHandler->getDisplayObjectId( obj );
        }
    }

    // Check if id is valid
    if ( collidableId != 0  )
    {
        if ((collidableId & 0x3) == 0x3)
            collidableId &= ~0x3;
        else if ((collidableId % 4) != 0)
            return false; // no pick (sweep shape display object or something)
    }

    hkpWorld* world =  m_commonCore->m_assetManager->m_currentWorld;
    if (world!= HK_NULL)
    {
        hkpRigidBody* rb = _findCollidableInWorld(collidableId, world);
        if (rb )
        {
            HK_ASSERT_NO_MSG(0xa74fb819, rb == hkpGetRigidBody((hkpCollidable*)collidableId));
            return true;
        }
    }
    return false;
}


void PreviewPluginPhysicsImpl::objectPicked(const ObjectPickInfo& obj, float* worldPos)
{
    if ( !m_commonCore->m_displayHandler || !m_commonCore->m_assetManager || !m_commonCore->m_assetManager->m_currentWorld )
    {
        return;
    }

    const int userPtrType = obj.m_object->getUserPointerType();
    if ((userPtrType == hkgDisplayObject::USER_POINTER_BREAKABLE_BODY) ||
        (userPtrType == hkgDisplayObject::USER_POINTER_ND_BREAKABLE_BODY))
    {
        return;
    }

    {
        hkpRigidBody* rb = HK_NULL;
        {
            hkUint64 collidableId = m_commonCore->m_displayHandler->getDisplayObjectId( obj.m_object );

            if (collidableId == 0) //then try the ghost display
            {
                if ( m_commonCore->m_assetManager && m_commonCore->m_assetManager->m_ghostDisplayHandler)
                {
                    collidableId = m_commonCore->m_assetManager->m_ghostDisplayHandler->getDisplayObjectId( obj.m_object  );
                }
            }

            // Check if id is valid
            if ( collidableId != 0  )
            {
                if ((collidableId & 0x3) == 0x3)
                    collidableId &= ~0x3;
                else if ((collidableId % 4) != 0)
                    return; // no pick (sweep shape display object or something)
            }

            hkpCollidable* cd = (hkpCollidable*)collidableId;
            if ( (cd != HK_NULL) && cd->getOwner() )
            {
                rb = hkpGetRigidBody(cd);
            }
        }

        if ( !rb )
        {
            return;
        }

        {
            rb->markForWrite();
            m_commonCore->m_assetManager->m_currentWorld->markForWrite();

            m_mouseSpring = new hkpMouseSpringAction( rb );

            if ( rb->isAddedToWorld() )
            {
                rb->activate();
            }

            m_mouseSpring->m_mousePositionInWorld.set(worldPos[0], worldPos[1], worldPos[2]);
            m_mouseSpring->m_positionInRbLocal.setTransformedInversePos( rb->getTransform(), m_mouseSpring->m_mousePositionInWorld);
            m_commonCore->m_assetManager->m_currentWorld->addAction( m_mouseSpring );

            rb->unmarkForWrite();
            m_commonCore->m_assetManager->m_currentWorld->unmarkForWrite();
        }
    }
}

void PreviewPluginPhysicsImpl::objectMoved( float* worldPos )
{
    if (m_mouseSpring)
    {
        hkpRigidBody* rb = m_mouseSpring->getRigidBody();
        if ( rb && rb->isAddedToWorld() )
        {
            m_commonCore->m_assetManager->m_currentWorld->markForWrite();
            rb->activate();
            m_commonCore->m_assetManager->m_currentWorld->unmarkForWrite();
        }

        m_mouseSpring->m_mousePositionInWorld.set(worldPos[0], worldPos[1], worldPos[2]);
    }
}

void PreviewPluginPhysicsImpl::objectReleased( )
{
    if (m_mouseSpring)
    {
        if ( m_mouseSpring->getWorld() )
        {
            m_commonCore->m_assetManager->m_currentWorld->lock();
            m_commonCore->m_assetManager->m_currentWorld->removeAction( m_mouseSpring );
            m_commonCore->m_assetManager->m_currentWorld->unlock();
        }
        m_mouseSpring->removeReference();
        m_mouseSpring = HK_NULL;
    }
}

bool PreviewPluginPhysicsImpl::objectAllowTransformInsteadOfMove()
{
    return !m_isPhysPlaying || !m_mouseSpring;
}

void PreviewPluginPhysicsImpl::objectTransform( float* newTransform )
{
    if (m_mouseSpring) // use the ms to get the rb
    {
        hkpRigidBody* rb = m_mouseSpring->getRigidBody();
        if (rb)
        {
            hkTransform t;
            t.set4x4ColumnMajor( newTransform );
            rb->setTransform(t);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
