// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewControl.h>

#pragma unmanaged
#include <Common/Base/hkBase.h>
#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>
#include <Plugins/Preview/Physics/hctPreviewPhysics.h>
#ifdef HK_ENABLE_PHYSICS
#include <NewPhysics/hctPreviewNewPhysics.h>
#endif
#pragma managed

using namespace PreviewPlugin;

// Setup

void hctPreviewControl::initPhysicsUI()
{
    if (m_si)
    {
        // Make impl
        m_si->m_physicsImpl = new PreviewPluginPhysicsImpl(m_si);
        m_si->m_allImpls.pushBack(m_si->m_physicsImpl);

        // Set some UI state
        PreviewPluginPhysicsImpl* phys = (PreviewPluginPhysicsImpl*) m_si->m_physicsImpl;
        phys->m_isPhysPlaying = boxPhysicsCheckBox->Checked;

        m_si->m_assetManager->m_ghostsEnabled = showCollShapeCheckBox->Checked;
        m_si->m_assetManager->m_hideRbMeshes = !showDisplayMeshCheckBox->Checked;

        m_si->m_assetManager->m_desiredGravity.load4(&m_si->m_assetManager->m_loadedGravity(0));
        gravityComboBox->SelectedIndex = 0;
    }
}

void hctPreviewControl::configurePhysicsFromUI()
{
    showCollShapeCheckBox_CheckedChanged(nullptr, nullptr);
    showDisplayMeshCheckBox_CheckedChanged(nullptr, nullptr);
    comboBoxGravity_SelectedIndexChanged(nullptr, nullptr);
}

//
// Form callbacks
//

System::Void hctPreviewControl::physicsCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_physicsImpl)
        ((PreviewPluginPhysicsImpl*)m_si->m_physicsImpl)->m_isPhysPlaying = boxPhysicsCheckBox->Checked;
#ifdef HK_ENABLE_PHYSICS
    if (m_si && m_si->m_newPhysicsImpl)
        ((PreviewPluginNewPhysicsImpl*)m_si->m_newPhysicsImpl)->m_isNewPhysPlaying = boxPhysicsCheckBox->Checked;
#endif
}

System::Void hctPreviewControl::showCollShapeCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_physicsImpl)
    {
        m_si->m_assetManager->toggleGhostTransparency( showCollShapeCheckBox->Checked );
    }
}

System::Void hctPreviewControl::showDisplayMeshCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    showBbCheckbox->Checked = showDisplayMeshCheckBox->Checked;

    if (m_si && m_si->m_physicsImpl)
    {
        m_si->m_assetManager->toggleRbDisplay( showDisplayMeshCheckBox->Checked );
    }
    if ( m_si && (m_si->m_destructionImpl || m_si->m_newDestructionImpl) )
    {
        m_si->m_assetManager->toggleBbDisplay( showBbCheckbox->Checked );
    }
}


System::Void hctPreviewControl::comboBoxGravity_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_physicsImpl)
    {
        float G[] = {
            m_si->m_assetManager->m_loadedGravity(0), m_si->m_assetManager->m_loadedGravity(1), m_si->m_assetManager->m_loadedGravity(2),
            0,0,0, // None
            9.81f,0,0, // X
            0,9.81f,0, // Y
            0,0,9.81f, // Z
            -9.81f,0,0, // -X
            0,-9.81f,0, // -Y
            0,0,-9.81f // -Z
        };

        m_si->m_assetManager->m_desiredGravity.set( G[gravityComboBox->SelectedIndex * 3], G[gravityComboBox->SelectedIndex * 3 + 1], G[gravityComboBox->SelectedIndex * 3 + 2] );
    }
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
