// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class PreviewPluginPhysicsImpl : public PreviewPluginProductImpl
{
    public:

        PreviewPluginPhysicsImpl(struct PreviewPluginImpl* c) :
            PreviewPluginProductImpl(c),
            m_mouseSpring(HK_NULL),
            m_isPhysPlaying(true)
            { }

        virtual void step( float dt );

        virtual bool ownsDisplayObject( class hkgDisplayObject* obj );

        virtual void objectPicked( const ObjectPickInfo& obj, float* worldPos);
        virtual void objectMoved( float* worldPos);
        virtual void objectReleased( );
        virtual bool objectAllowTransformInsteadOfMove( );
        virtual void objectTransform( float* newTransform );

        virtual void tweakGetDataAndClass( const ObjectPickInfo&, void*& dataPtr, const hkReflect::Type*& klassPtr );
        virtual void tweakVerifyClass( const hkReflect::Type* klassPtr );
        virtual void tweakCommit( void* origData, const hkReflect::Type* origKlass, void* newData );

        virtual void startPlay();
        virtual void stopPlay();

        hkpMouseSpringAction* m_mouseSpring;
        bool m_isPhysPlaying;

};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
