// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : ANIMATION+PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged


#include <Common/Base/hkBase.h>
#include <Plugins/Preview/hctPreviewAsset.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>

#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Mesh/hkxMesh.h>

#include <Animation/Animation/Rig/hkaPose.h>
#include <Animation/Animation/Mapper/hkaSkeletonMapper.h>
#include <Animation/Animation/hkaAnimationContainer.h>

#include <Animation/Physics2012Bridge/Instance/hkaRagdollInstance.h>
hkaRagdollInstance* find2012RagdollFromSkeleton ( const hkArray<hkaRagdollInstance*>& ragdolls, const hkaSkeleton* skeleton)
{

    for (int ri=0; ri < ragdolls.getSize(); ++ri)
    {
        if (ragdolls[ri]->getSkeleton() == skeleton)
        {
            return ragdolls[ri];
        }
    }
    return HK_NULL;
}


bool PreviewPlugin::PreviewAssetManager::is2012RagdollSkeleton( const hkaSkeleton* skeleton )
{
    return (find2012RagdollFromSkeleton(m_2012ragdolls, skeleton) != HK_NULL);
}

int PreviewPlugin::PreviewAssetManager::addCompletePhysics2012Objects(PreviewPlugin::PreviewAsset* asset)
{
    hkRootLevelContainer* container = asset->m_container;
    hkaAnimationContainer* animContainer = container->findObject<hkaAnimationContainer>();

    // find any ragdolls. assume they are in the same order as the above mappers
    hkaRagdollInstance* ragdoll = container->findObject<hkaRagdollInstance>(HK_NULL);

    int found = 0;
    m_displayHandler->setAllowColorChangeOnPrecreated(true);

    while (ragdoll)
    {
        m_2012ragdolls.pushBack(ragdoll);
        ++found;
        // as a ragdoll is assumed to have a skinned character attached, we automatically remove
        // its display objects
        const hkArray<hkpRigidBody*>& rbs = ragdoll->getRigidBodyArray();

        for (hkInt16 rbi=0; rbi < rbs.getSize(); ++rbi)
        {
            hkpRigidBody* rb = rbs[rbi];

            hkUint64 id = hkUint64(rb->getCollidable());

            hkgDisplayObject* dispObj = m_displayHandler->findDisplayObject(id);
            // EXP-873
            if (dispObj)
            {
                // EXP-1109: make them permanently so..

                // If the scene converter has it:
                for (int mi=0; mi < asset->m_convertedGraphicsObjects->m_meshes.getSize(); ++mi)
                {
                    if (asset->m_convertedGraphicsObjects->m_meshes[mi].m_hkgObject == dispObj)
                    {
                        asset->m_convertedGraphicsObjects->m_meshes.removeAt(mi);
                        dispObj->removeReference(); // converter ref
                        break; // done
                    }
                }

                // If the display handler has it (which it does, as we got the oid from there)
                // It will remove it from the world, and its internal lists
                m_displayHandler->removeGeometry(id);
            }
        }

        // we don't want the animation system thinking our ragdoll skel is a proper skel
        // so we can remove it (null it) out of the normal skel list if it is there

        // next
        ragdoll = container->findObject<hkaRagdollInstance>(ragdoll);
    }
    return found;
}

void PreviewPlugin::PreviewAssetManager::removeCompletePhysics2012Objects(PreviewAsset* asset)
{
    hkRootLevelContainer* container = asset->m_container;
    hkaAnimationContainer* animContainer = container->findObject<hkaAnimationContainer>();
    if (animContainer)
    {
        // Ragdolls
        hkaRagdollInstance* ragdoll = container->findObject<hkaRagdollInstance>(HK_NULL);
        while (ragdoll)
        {
            int ri = m_2012ragdolls.indexOf(ragdoll);
            if (ri >= 0)
            {
                m_2012ragdolls.removeAt(ri);
            }

            // next for this asset
            ragdoll = container->findObject<hkaRagdollInstance>(ragdoll);
        }
    }
}

void PreviewPlugin::PreviewAssetManager::update2012RagdollMapping( const hkaSkeleton* ragdollSkel )
{
    hkaRagdollInstance* ragdoll = find2012RagdollFromSkeleton (m_2012ragdolls, ragdollSkel);

    if (ragdoll)
    {
        const hkArray<hkpRigidBody*>& rbArray = ragdoll->getRigidBodyArray();
        for (int rbi=0; rbi < rbArray.getSize(); ++rbi)
        {
            hkpRigidBody* rb = rbArray[rbi];
            switch (m_ragdollMappingType)
            {
                case NO_RAGDOLL_MAPPING:// Bodies should be free to move
                case RAGDOLL_TO_ANIM_MAPPING:
                    if (rb->getMotionType() == hkpMotion::MOTION_KEYFRAMED)
                    {
                        // TODO: Reset to a cached state (as set by user) not just assume box and moving.
                        rb->setMotionType(hkpMotion::MOTION_BOX_INERTIA);
                        rb->setQualityType(HK_COLLIDABLE_QUALITY_MOVING);
                    }
                    break;
                case ANIM_TO_RAGDOLL_MAPPING: // Bodies need to be keyframed
                    if (rb->getMotionType() != hkpMotion::MOTION_KEYFRAMED)
                    {
                        rb->setMotionType(hkpMotion::MOTION_KEYFRAMED);
                        rb->setQualityType(HK_COLLIDABLE_QUALITY_KEYFRAMED);
                    }
                    break;
            }
        }
    }

}

void PreviewPlugin::PreviewAssetManager::step2012Ragdoll(
const hkaSkeleton* animSkeleton, const hkaSkeleton* ragdollSkeleton, const hkQsTransform& worldFromModel, hkaPose& animationPose ) const
{
    hkaRagdollInstance* ragdoll = find2012RagdollFromSkeleton (m_2012ragdolls, ragdollSkeleton);


    if (ragdoll)
    {
        hkaPose ragdollPose(ragdollSkeleton);
        ragdoll->getPoseModelSpace(ragdollPose.accessUnsyncedPoseModelSpace().begin(), worldFromModel);

        if (m_ragdollMappingType == PreviewAssetManager::RAGDOLL_TO_ANIM_MAPPING)
        {
            // RAGDOLL_2_ANIM
            const hkaSkeletonMapper* ragdollToAnim = findMapperFromSkeleton (ragdollSkeleton);

            ragdollToAnim->mapPose( ragdollPose, animationPose, hkaSkeletonMapper::CURRENT_POSE );
        }
        else // ANIM_2_RAGDOLL
        {
            const hkaSkeletonMapper* animToRagdoll = findMapperFromSkeleton( animSkeleton );
            animToRagdoll->mapPose(animationPose, ragdollPose, hkaSkeletonMapper::CURRENT_POSE );

            // set the ragdoll bone transforms
            ragdoll->setPoseModelSpace(ragdollPose.accessSyncedPoseModelSpace().begin(), worldFromModel );
        }
    }
}
#pragma managed

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
