// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <ContentTools/Common/StandAloneFilterManager/standaloneFilterManagerOptions.h>
#include <Common/Base/Config/hkConfigVersion.h>

hctStandaloneFilterManagerOptions::hctStandaloneFilterManagerOptions() :
    m_forceInteractive(0),
    m_optionsPath(""),
    m_assetPath(""),
    m_outputPath(""),
    m_logFile("")
{}

hkOptionParser::ParseResult hctStandaloneFilterManagerOptions::parse(int argc, const char** argv)
{
    hkOptionParser parser(
        "Havok Content Tools Standalone Filter Manager",
        "Opens files for processing in the filter manager");

    hkOptionParser::Option options[] =
    {
        hkOptionParser::Option("s", "settings", "specifies a filter set (i.e., a .hko file) to use", &m_optionsPath, "defaults.hko"),
        hkOptionParser::Option("p", "asset", "the asset path to use (used when using .hkx files which created using relative paths)", &m_assetPath),
        hkOptionParser::Option("o", "output", "the output path. If left unspecified, the current working directory is used", &m_outputPath),
        hkOptionParser::Option("i", "interactive", "forces interactive mode", &m_forceInteractive),
        hkOptionParser::Option("l", "logfile", "specify the log file", &m_logFile, "filterLog.txt"),
        hkOptionParser::Option("t", "standard", "whether the output from the filter manager is printed to the standard output or not", &m_verbose),
        hkOptionParser::Option("v", "verbose", "the level of verbose output to the log file (0 - No log written, 1 - Warnings and Errors only, 2 - Full output is written)", &m_verboseLog, 2),
    };

    if (!parser.setOptions(options, HK_COUNT_OF(options)))
    {
        // Invalid options
        return hkOptionParser::PARSE_FAILURE;
    }

    const char* arguments[s_numberOfInputFiles];
    parser.setArguments("file.hkx", "input files that will be merged together and processed through the filter pipeline", hkOptionParser::ARGUMENTS_ZERO_OR_MORE, arguments, HK_COUNT_OF(arguments));

    hkOptionParser::ParseResult result = parser.parse(argc, argv);

    if (result == hkOptionParser::PARSE_SUCCESS)
    {
        int numFiles;
        for (numFiles = 0; numFiles < s_numberOfInputFiles; numFiles++)
        {
            if (arguments[numFiles] == HK_NULL)
            {
                break;
            }
            m_arguments.pushBack(hkStringOld(arguments[numFiles]));
        }

        //if there are no files, then always want to open the stand-alone filter dialog.
        if(numFiles == 0)
        {
            m_forceInteractive = true;
        }
    }

    return result;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
