// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>
#include <Common/Base/Config/hkConfigVersion.h>

#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

#include <ContentTools/Common/StandAloneFilterManager/standaloneFilterManager.h>
#include <ContentTools/Common/Filters/Common/Utils/hctFilterUtils.h>
#include <ContentTools/Common/Filters/Common/Utils/hctFilterDialogUtils.h>

#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ContentTools/Common/StandAloneFilterManager/resource.h>


struct
{
    Graphics* g;
    Bitmap* b;
} hkGdiInfo;


LRESULT CALLBACK SplashWndProc(HWND, UINT, WPARAM, LPARAM);

LRESULT CALLBACK SplashWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
        case WM_TIMER:
        {
            switch( wParam )
            {
                case splashTimer: DestroyWindow(hwnd);
            }
            break;
        }

        case WM_CREATE:
        {
            hkGdiInfo.g = new Graphics(hwnd, false);

            HDC screenDc = GetDC(NULL);
            HDC memDc = CreateCompatibleDC(screenDc);

            HBITMAP hBitmap;
            Color col(0,0,0,0);
            hkGdiInfo.b->GetHBITMAP(col, &hBitmap);

            HBITMAP oldBitmap;
            oldBitmap = (HBITMAP)SelectObject(memDc, hBitmap);

            RECT deskRect;
            HWND desktop = GetDesktopWindow();
            GetWindowRect(desktop, &deskRect);
            deskRect.left = (deskRect.left < 0)  ? 0 : deskRect.left;

            RECT splashRect;
            GetWindowRect(hwnd, &splashRect);
            int X = (deskRect.right + deskRect.left) /2 - (splashRect.right - splashRect.left) /2;
            int Y = (deskRect.bottom + deskRect.top) /2 - (splashRect.bottom - splashRect.top) /2;

            SIZE size; size.cx = hkGdiInfo.b->GetWidth(); size.cy = hkGdiInfo.b->GetHeight();
            POINT pointSource; pointSource.x = 0; pointSource.y = 0;
            POINT topPos; topPos.x = X; topPos.y = Y;

            BLENDFUNCTION blend;
            blend.BlendOp             = AC_SRC_OVER;
            blend.BlendFlags          = 0;
            blend.SourceConstantAlpha = 255;
            blend.AlphaFormat         = AC_SRC_ALPHA;
            UpdateLayeredWindow(hwnd, screenDc, &topPos, &size, memDc, &pointSource, 0, &blend, ULW_ALPHA);

            ReleaseDC(NULL, screenDc);
            if (hkGdiInfo.b != NULL)
            {
                SelectObject(memDc, oldBitmap);
                DeleteObject(hBitmap);
            }
            DeleteDC(memDc);

            break;
        }

        case WM_CLOSE:
        {
            DestroyWindow(hwnd);
            break;
        }
    }

    return TRUE;
}


bool HK_CALL hkCreateSplashWindow(HINSTANCE hInstance)
{
    // Fill in the window class structure with parameters
    // that describe the splash window.
    WNDCLASSEXW wcx;
    wcx.cbSize = sizeof(wcx);            // size of structure
    wcx.style = CS_HREDRAW | CS_VREDRAW; // redraw if size changes
    wcx.lpfnWndProc = SplashWndProc;     // points to window procedure
    wcx.cbClsExtra = 0;                  // no extra class memory
    wcx.cbWndExtra = 0;                  // no extra window memory
    wcx.hInstance = hInstance;           // handle to instance
    wcx.lpszClassName = L"SplashWClass";  // name of window class
    wcx.hIcon = NULL;
    wcx.hCursor = NULL;
    wcx.hbrBackground = NULL;
    wcx.lpszMenuName = NULL;
    wcx.hIconSm = NULL;

    // Register the window class.
    if ( !RegisterClassExW(&wcx) ) return FALSE;

    hkGdiInfo.b = new Bitmap(L"Data\\splash.png");

    HWND hwnd;
    hwnd = CreateWindowExW(  WS_EX_LAYERED | WS_EX_TOPMOST | WS_EX_TRANSPARENT | WS_EX_TOOLWINDOW,
                            L"SplashWClass",      // name of window class
                            L"",                  // title-bar string
                            WS_VISIBLE,          // top-level window
                            CW_USEDEFAULT,       // default horizontal position
                            CW_USEDEFAULT,       // default vertical position
                            hkGdiInfo.b->GetWidth(),
                            hkGdiInfo.b->GetHeight(),
                            (HWND) NULL,         // no owner window
                            (HMENU) NULL,        // use class menu
                            hInstance,           // handle to application instance
                            (LPVOID) NULL);      // no window-creation data

    if (!hwnd) return FALSE;

    SetTimer(hwnd,              // handle to main window
             splashTimer,       // timer identifier
             1500,              // 1-second interval
             (TIMERPROC) NULL); // no timer callback

    return TRUE;
}


void HK_CALL hkShowSplash(HINSTANCE hInstance)
{
    ULONG_PTR gdiplusToken;
    GdiplusStartupInput gdiplusStartupInput;
    GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);

    hkCreateSplashWindow(hInstance);

    GdiplusShutdown(gdiplusToken);
}


UINT_PTR CALLBACK hkDlgHook(HWND hdlg,UINT uiMsg,WPARAM wParam,LPARAM lParam)
{
    switch (uiMsg)
    {
        case WM_INITDIALOG:
        {
            RECT deskRect, dlgRect;
            HWND fDlg = GetParent(hdlg);
            GetWindowRect(fDlg, &dlgRect);
            GetWindowRect(GetWindow(fDlg,GW_HWNDLAST),&deskRect);
            deskRect.left = (deskRect.left < 0)  ? 0 : deskRect.left;
            int x = (deskRect.right + deskRect.left) /2 - (dlgRect.right - dlgRect.left) /2;
            int y = (deskRect.bottom + deskRect.top) /2 - (dlgRect.bottom + dlgRect.top) /2;
            SetWindowPos(fDlg,NULL,x,y,0,0,SWP_NOSIZE | SWP_NOZORDER);

            // Change button names
            SetWindowText(GetDlgItem(fDlg, 1), "&Load");
            SetWindowText(GetDlgItem(fDlg, 2), "Done");
        }
        return TRUE;
    }
    return FALSE;
}

bool HK_CALL hkGetOptions(hctStandaloneFilterManagerOptions &options, hkArray<hkStringOld>& buffer)
{
    int argc;
    LPWSTR* wargv = CommandLineToArgvW( GetCommandLineW() , &argc);
    const char** argv = new const char*[argc];

    for (int i=0; i < argc; i++)
    {
        hkStringOld arg = hkUtf8::Utf8FromWide( wargv[i] );
        buffer.pushBack(arg);
        argv[i] = buffer.back().cString();
    }

    bool res = (options.parse(argc, argv) == hkOptionParser::PARSE_SUCCESS);
    delete argv;

    return res;
}

struct AssetPathChoice
{
    hkArray<const wchar_t*>* choiceStrs;
    hkStringOld m_initialScenePath;
    hkStringOld retStr;
};

static void _fillCombo(HWND combo, hkArray<const wchar_t*>& strs)
{
    SendMessage(combo, CB_RESETCONTENT, 0, 0);
    int ni = strs.getSize();
    for (int i=0; i < ni; ++i)
    {
        const wchar_t* s = strs[i];
        if (s)
            SendMessageW(combo, CB_ADDSTRING, 0, (LPARAM)s);
    }
    SendMessageW(combo, CB_SETCURSEL, 0, (LPARAM)0);
}

static int CALLBACK BrowseFolderCallback(
    HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
    if (uMsg == BFFM_INITIALIZED) {
        LPCTSTR path = reinterpret_cast<LPCTSTR>(lpData);
        ::SendMessage(hwnd, BFFM_SETSELECTION, true, (LPARAM)path);
    }
    return 0;
}


INT_PTR CALLBACK hkAssetPathProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    AssetPathChoice* data = reinterpret_cast<AssetPathChoice*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;
    switch (message)
    {
    case WM_INITDIALOG:
        {
            data = (AssetPathChoice*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            _fillCombo(GetDlgItem(hWnd, IDC_COMBO_PATHS), *(data->choiceStrs) );
        }
        // FALL THROUGH
    case WM_SIZE:
        {
            RECT wndRect; GetClientRect(hWnd, (LPRECT)&wndRect);

            SetWindowPos(GetDlgItem(hWnd, IDOK), NULL,
                wndRect.right - 164, wndRect.bottom - 30, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
            SetWindowPos(GetDlgItem(hWnd, IDCANCEL), NULL,
                wndRect.right - 83, wndRect.bottom - 30, 0, 0, SWP_NOZORDER | SWP_NOSIZE);

            SetWindowPos(GetDlgItem(hWnd, IDC_COMBO_PATHS), NULL,
                13, 30, wndRect.right - 98, 458, SWP_NOZORDER);

            SetWindowPos(GetDlgItem(hWnd, IDC_BUTTON_PICK), NULL,
                wndRect.right - 83, 30, 0, 0, SWP_NOZORDER | SWP_NOSIZE);

            InvalidateRect(hWnd, NULL, TRUE);
            UpdateWindow(hWnd);
        }
        break;
    case WM_GETMINMAXINFO:
        {
            LPMINMAXINFO lpMMI = (LPMINMAXINFO)lParam;
            lpMMI->ptMinTrackSize.x = 475;
            lpMMI->ptMinTrackSize.y = 146;

            lpMMI->ptMaxTrackSize.y = 146;
        }
        break;

    case WM_COMMAND:
    {
        switch ( LOWORD(wParam) )
        {
        case IDOK:
        {
            hkStringPtr assetPath;
            hctGetDlgItemHkStringPtr(hWnd, IDC_COMBO_PATHS, assetPath);

            hkStringBuf pickedAssetPath = assetPath;
            bool isDirectory = pickedAssetPath.pathBasename().isEmpty();

            hkIfstream file(assetPath.cString());
            if (!file.isOk() && !isDirectory)
            {
                if (MessageBox(NULL,
                    "Provided asset path doesn't exist which will result in the $(assetFolder) and $(assetPath) environment variables "
                    "being unusable and textures not being found. ",
                    "Invalid Asset Path",
                    MB_OKCANCEL | MB_ICONWARNING | MB_TASKMODAL | MB_TOPMOST) == IDOK)
                {
                    data->retStr = assetPath;
                    EndDialog(hWnd, IDOK);
                }
            }
            else
            {
                data->retStr = assetPath;
                EndDialog(hWnd, IDOK);
            }
            return TRUE;
        }

        case IDCANCEL:
        {
            int lastIdx = (*data->choiceStrs).getSize() - 1;

            hkUtf8::Utf8FromWide assetPath((*data->choiceStrs)[lastIdx]);

            hkStringBuf pickedAssetPath = assetPath;
            bool isDirectory = pickedAssetPath.pathBasename().isEmpty();

            hkIfstream file(assetPath.cString());
            if (!file.isOk() && !isDirectory)
            {
                if (MessageBox(NULL,
                    "Environment asset path doesn't exist which will result in the $(assetFolder) and $(assetPath) environment variables "
                    "being unusable and textures not being found. ",
                    "Invalid Optional Asset Path",
                    MB_OKCANCEL | MB_ICONWARNING | MB_TASKMODAL | MB_TOPMOST) == IDOK)
                {
                    data->retStr = "";
                    EndDialog(hWnd, IDCANCEL);
                }
            }
            else
            {
                data->retStr = "";
                EndDialog(hWnd, IDCANCEL);
            }

            return TRUE;
        }

        case IDC_BUTTON_PICK:
        {
            hkStringBuf initialSceneDir = data->m_initialScenePath.cString();
            initialSceneDir.pathDirname();

            const int filenameLen = 2048;
            wchar_t filename[filenameLen];
            filename[0] = '\0';

            // In the case of multiple scene files loaded, specify a directory
            if(data->choiceStrs->getSize() > 1)
            {
                LPMALLOC pMalloc;
                SHGetMalloc(&pMalloc);

                BROWSEINFOW browseInfo;
                hkString::memSet(&browseInfo, 0, sizeof(browseInfo));
                browseInfo.hwndOwner = hWnd;
                browseInfo.lpszTitle = L"Please select an asset folder for the hkxEnvironment";
                browseInfo.ulFlags = BIF_USENEWUI;

                browseInfo.pszDisplayName = filename;

                browseInfo.lParam = (LPARAM)initialSceneDir.cString();
                browseInfo.lpfn = BrowseFolderCallback;

                LPITEMIDLIST folders = SHBrowseForFolderW(&browseInfo);
                if (folders && SHGetPathFromIDListW(folders, filename))
                {
                    int dnl = static_cast<int>(wcslen(filename));
                    if (dnl < MAX_PATH - 1)
                    {
                        if ((dnl > 0) && (filename[dnl - 1] != L'\\'))
                            filename[dnl] = L'\\'; // add a backslash to the end
                        filename[dnl + 1] = L'\0';
                    }

                    SendMessageW(GetDlgItem(hWnd, IDC_COMBO_PATHS), WM_SETTEXT, 0, (LPARAM)filename);
                }
                pMalloc->Free(folders);
                pMalloc->Release();
            }
            else
            {
                // In the case of a single scene file, specify a filepath
                OPENFILENAMEW op;
                hkString::memSet(&op, 0, sizeof(OPENFILENAMEW));
                op.lStructSize = sizeof(OPENFILENAMEW);
                op.hwndOwner = hWnd;
                op.lpstrTitle = L"Please select an asset path for the hkxEnvironment";

                hkUtf8::WideFromUtf8 assetFolderWide(initialSceneDir.cString());
                op.lpstrInitialDir = assetFolderWide;
                op.nMaxFile = filenameLen;
                op.Flags = OFN_ENABLESIZING | OFN_EXPLORER | OFN_PATHMUSTEXIST;

                if(!(*data->choiceStrs).isEmpty())
                {
                    int lastIdx = (*data->choiceStrs).getSize() - 1;
                    hkUtf8::Utf8FromWide originalAssetPath((*data->choiceStrs)[lastIdx]);

                    // Use the original asset path if it exists
                    hkIstream stream( originalAssetPath.cString());
                    if (stream.isOk())
                    {
                        wcsncpy(filename, ((*data->choiceStrs)[lastIdx]), filenameLen);

                        op.Flags = op.Flags | OFN_FILEMUSTEXIST;
                    }
                    else if (!initialSceneDir.isEmpty())
                    {
                        // Try using the scene file's directory with the original asset's base name
                        hkStringBuf originalAssetBaseName = originalAssetPath.cString();

                        originalAssetBaseName.pathBasename();

                        hkStringBuf newAssetPath;
                        newAssetPath.pathAppend(initialSceneDir, originalAssetBaseName);
                        newAssetPath.replace('/', '\\', hkStringBuf::REPLACE_ALL);

                        wcsncpy(filename, hkUtf8::WideFromUtf8(newAssetPath.cString()), filenameLen);

                        op.Flags = op.Flags | OFN_FILEMUSTEXIST;
                    }
                }

                op.lpstrFile = filename;

                if (GetOpenFileNameW(&op))
                {
                    SendMessageW(GetDlgItem(hWnd, IDC_COMBO_PATHS), WM_SETTEXT, 0, (LPARAM)op.lpstrFile);
                }
            }

            return TRUE;
        }
        }
    }
    }

    return FALSE;
}


void HK_CALL hkGetAssetPath( hkArray<hkStringPtr>& assetPaths, hkArray<hkStringPtr>& sceneFilePaths, hkStringOld& assetPathOut )
{
    hkArray<hkArray<wchar_t> > szBuf;
    // reduce assetPaths to minimal set
    hkArray<const wchar_t*> reducedSet;
    for (int i=0; i < assetPaths.getSize(); ++i)
    {
        szBuf.setSize(assetPaths.getSize());
        int j=0;
        for (; j < reducedSet.getSize(); ++j)
        {
            if (wcscmp(hkUtf8::WideFromUtf8(assetPaths[i]).cString(), reducedSet[j])==0)
                break;
        }
        if (j == reducedSet.getSize())
        {
            //[EXP-2832] Chinese character support in both input/output path
            hkUtf8::WideFromUtf8 temp( assetPaths[j] );
            szBuf[i] = hkArrayView<const wchar_t>( temp.cString(), temp.getLength() + 1 ); // + null terminator
            reducedSet.pushBack(&szBuf[i][0]);
        }
    }

    // bring up dialog listing current assetPaths
    AssetPathChoice apc;
    apc.choiceStrs = &reducedSet;
    if (!sceneFilePaths.isEmpty())
    {
        apc.m_initialScenePath = sceneFilePaths[sceneFilePaths.getSize() - 1];
    }

    apc.retStr = "";

    DialogBoxParamW(HK_NULL, MAKEINTRESOURCEW(IDD_ASSET_PATH_DIALOG),
                   HK_NULL, hkAssetPathProc, (LPARAM)&apc);

    assetPathOut = apc.retStr;

    printf(" ASSETPATH: %s\n", assetPathOut.cString());

}

void HK_CALL hkGetFiles( hkArray<hkStringOld>& filenames)
{
    wchar_t fileBuf[2048];
    fileBuf[0] = '\0';

    wchar_t title[255];
    const char version[] = HAVOK_REFLECTION_VERSION_NUM_STRING;
    wsprintfW(title, L"Havok Standalone Filter Manager v %s [No files loaded]", hkUtf8::WideFromUtf8(version).cString());

    char errorMsg[255];
    errorMsg[0] = '\0';

    OPENFILENAMEW ofn;
    ofn.lStructSize = sizeof(OPENFILENAMEW);
    ofn.hwndOwner = HK_NULL;
    ofn.hInstance = HK_NULL;
    ofn.lpstrFilter = hctFilterUtils::s_DialogFileExtensions;
    ofn.lpstrCustomFilter = HK_NULL;
    ofn.lpstrFile = fileBuf;
    ofn.nMaxFile = 2048;
    ofn.lpstrFileTitle = HK_NULL;
    ofn.lpstrInitialDir = HK_NULL;
    ofn.lpstrTitle = title;
    ofn.Flags = OFN_ALLOWMULTISELECT | OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_ENABLEHOOK | OFN_ENABLESIZING;
    ofn.lpstrDefExt = L"hkx";
    ofn.nFilterIndex = 1;
    ofn.lpfnHook = hkDlgHook;

    while ( GetOpenFileNameW(&ofn) )
    {
        hkUtf8::Utf8FromWide filenameUtf8(ofn.lpstrFile);
        hkStringOld path(filenameUtf8);

        int lastDot = path.lastIndexOf('.');
        //if you select multiple files then the ofn.lpstrFile drop 000.hkt
        //but if you select only one file then keep 000.hkt data in ofn.lpstrFile
        if(lastDot > ofn.nFileOffset)
        {
            int lastSlash = path.lastIndexOf('\\');
            path = path.substr(0, lastSlash);
        }
        path += "\\";

        hkUtf8::WideFromUtf8 w(path.cString());

        while( fileBuf[ofn.nFileOffset] != '\0' )
        {
            //[EXP-2818] Cannot load asset from path including Chinese Chars
            hkUtf8::Utf8FromWide filenamePlusOffsetUtf8(ofn.lpstrFile + ofn.nFileOffset);
            hkStringOld filename( filenamePlusOffsetUtf8 );

            hkStringOld file = path + filename;
            if ( filenames.indexOf( file ) < 0 )
            {
                filenames.pushBack( file );
            }

            ofn.nFileOffset += ( filename.getLength() + 1 );
        }

        if (filenames.getSize() > 0)
        {
            wsprintfW( title, L"Havok Standalone Filter Manager v %s [%d file%s loaded]",
                hkUtf8::WideFromUtf8(version).cString(), filenames.getSize(), ( filenames.getSize() > 1 ) ? L"s" : L"" );
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
