// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>
#include <Common/Base/Fwd/hkwindows.h>

class hkStringOld;

#define HCT_MAX_NUM_CLASS_ENTRIES 128

struct hctModelerNodeIdToClassMap
{
    enum InternalClassification
    {
        SUPPORTED         = 0,
        UNDERGOING_REVIEW = 1,
        DEPRECATED        = 2
    };

    HK_DECLARE_POD_TYPE();
    int            m_3dsMaxClassId;
    int            m_mayaNodeId;
    const hkReflect::Type* m_class;
    const char*    m_nodeName;
    const char*    m_displayName;
    InternalClassification m_internalClassification;
};


class hctSdkUtils
{
    public:

        /// A modeler independent abstraction of a "progress bar", to monitor the utility's progress and terminate it if necessary
        struct ProgressUpdater
        {
            virtual HK_INLINE ~ProgressUpdater() {}
            virtual void progression (float percentage) =0;
            virtual bool didUserCancel () =0;

            const char* m_currentObjectName;
        };

        /// UI schemes
        enum UiSchemeTypes
        {
            UI_SCHEME_NONE              = 0,
            UI_SCHEME_DESTRUCTION_2012  = (1 << 0), ///< UI scheme is set to Destruction 2012
            UI_SCHEME_DESTRUCTION       = (1 << 1), ///< UI scheme is set to New Destruction
        };

        typedef hkFlags<UiSchemeTypes, hkUint8> UiScheme;

            /// loads all available class DLLs and retrieves the modeler node information
        static void loadAllClasses();

            /// unloads the available class DLLs and releases all memory
        static void unloadAllClasses();

            /// Loads all available utility Dlls
        static void loadAllUtils();

            /// Unloads all loaded utility Dlls
        static void unloadAllUtils();

            /// Finds all the classes that either match the class pointed to by targetAttributeName or inherit
            /// from it. If the target class isn't currently loaded, no matching classes are returned.
            /// Also, if the the targetAttributeName attribute is not a member of the specified class, no
            /// matching classes will be returned.
            /// Returns the number of matching classes
        static int getMatchingClasses(const char* targetNodeName, const char* targetAttributeName, hkArray<hkStringOld>& matchingClassesOut);

            /// Returns either the class or HK_NULL if not registered/loaded.
        static const hkReflect::Type* getTypeByName(const char* className);

            /// Fills the supplied array with those class map entries whose classes are derived from the supplied base class.
        static void getClassesByBaseName(const char* baseName, hkArray<hctModelerNodeIdToClassMap>& classesOut);

        static int getIndexByNodeName(const char* className);

        static const hkArray<hctModelerNodeIdToClassMap>& getNodeIdToClassMap() {return *m_modelerNodeIdToClassMap;}

            /// Returns the number of all registered classes.
        static int getNumUiClasses();

            /// Returns the i'th registered class from the table.
        static hctModelerNodeIdToClassMap& getUiClass(int i);

            // Sometimes there can be conflicts with certain modeler-internal objects/names.
            // This function helps in getting a non-colliding name for any given Havok name.
        static const char* getValidName(const char* name, hkStringOld& buffer);

            // This function will 'revert' getValidName() and will return the original name.
        static const char* revertValidName(const char* validModelerName, hkStringOld& buffer);

            // Get the name of the HCT .chm help file.
        static void getHelpFileName(hkStringOld& helpFile);

            // Get the path to the HCT documentation .CHM file.
        static void getPathToAndNameOfDocumentationChmFile(hkStringOld& docsPathAndFileName);

            // Get the filterManagerPath
        static void getFilterManagerPath(hkStringOld& filterManagerPath);

            // Opens the Video Browser.
        static bool openVideoBrowser(const char *commandLineArgs);

            // Opens the HCT Documentation .chm help file.
        static bool openDocumentationChmFile();

            /// Attempts to retrieve the given utility function from one of the loaded utility Dlls
        static void* HK_CALL getUtilityFunction(const char* functionName);

        /// Attempts to load the hctDestructionUtils.dll
        static void loadDestructionUtils();

        /// Attempts to unload the hctDestructionUtils.dll
        static void unloadDestructionUtils();

        /// Returns the current UI scheme
        static UiScheme getUiScheme();

        /// Returns the MD5 hash of the given data buffer
        static hkResult HK_CALL computeMd5Hash(const void* bufferIn, hkUint32 bufferSize, hkUint8* hashOut, int& hashSizeOut);

        /// Returns the UI attributes hide criteria
        static hkAttributeHideCriteria::Types HK_CALL getUiAttributesHideCriteria(hkAttributeHideCriteria::Types modelerId);

    private:

        /// Returns a module pointer if it is able to load the class DLL specified in the path
        static HMODULE loadClassDll(const char* dllName);

        /// Returns a module pointer if it is able to load the class DLL specified in the path
        static HMODULE loadUtilDll(const char* dllName);

        static hkArray<hctModelerNodeIdToClassMap>* m_modelerNodeIdToClassMap;

    public:

        /// Handle to hctDestructionUtils.dll
        static HMODULE m_destructionUtilsDll;

        /// Base Dll interface for hctDestructionUtils.dll
        static class hctBaseDll* m_baseDestructionUtilsDll;
        static class hctBaseDll* m_baseDestructionClassesDll;
};

/// Prototype for the DLL-exported method
typedef void (__cdecl *hkGetClassEntriesFunc) (hkArray<hctModelerNodeIdToClassMap>& classMap);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
