
@ECHO OFF

REM %1 == The name of the project that called the custom build step
REM %2 == The deployment dir (HAVOK_TOOLS_ROOT/HAVOK_TOOLS_ROOT_X64 environment variable)
REM %3 == The current platform - win32/x64
REM %4 == TargetPath 

if "%~2" == "" goto nodeploy

REM Save re-execution details in redeploy.bat
set REDEPLOY_FILE=%~dp0redeploy_%~n1.bat
if exist %REDEPLOY_FILE% del %REDEPLOY_FILE%
echo %~dpnx0 %* > %REDEPLOY_FILE%

setlocal

REM DLL env var setup
if "%~3" == "win32" goto win32
if "%~3" == "x64" goto x64
goto failure
:win32
set HCT_DLLS_SUBDIR=bin
goto dllend
:x64
set HCT_DLLS_SUBDIR=bin_x64
goto dllend
:dllend

REM Copy DLLs
mkdir "%~2\bin" > nul
xcopy "%HAVOK_THIRDPARTY_DIR%\sdks\win32\freeimage\%HCT_DLLS_SUBDIR%\*.dll" "%~2\bin" /s /y /r >nul
xcopy "%HAVOK_THIRDPARTY_DIR%\sdks\win32\freeimage\freeimage-license.txt" "%~2\bin" /s /y /r >nul
xcopy "%HAVOK_THIRDPARTY_DIR%\sdks\win32\nvtt\%HCT_DLLS_SUBDIR%\*.dll" "%~2\bin" /s /y /r >nul
xcopy "%HAVOK_THIRDPARTY_DIR%\sdks\win32\nvtt\nvidia-texture-tools-license.txt" "%~2\bin" /s /y /r >nul

if errorlevel 1 goto failure
echo Files copied to %2

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo Files copied to %2 > "%~4.output"

exit /b 0

endlocal 


:nodeploy

echo WARNING: HAVOK_TOOLS_ROOT is not defined. The deployment step has been skipped.

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo WARNING: HAVOK_TOOLS_ROOT is not defined. The deployment step has been skipped. > "%~3.output"
exit /b 0


:failure

echo Couldn't copy files to %2... 
echo Make sure DLLs are not in use and that HAVOK_TOOLS_ROOT is defined

REM Print an error message for the continuous integration system to detect.
echo ERROR: Custom build step failed.

REM Return an ErrorLevel of 1
exit /b 1