// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Common/SdkUtils/Scene/hctSceneUtils.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>

hkRootLevelContainer* hctSceneUtils::loadSceneFromStream( hkStreamReader& r, hkResource*& fileData )
{
    hkSerializeUtil::ErrorDetails err;
    fileData = hkSerializeUtil::load(&r, &err);
    if( !fileData )
    {
        HK_WARN_ALWAYS(0x7ec2790e, "Couldn't load file, skipping.");
        return HK_NULL;
    }

    hkRootLevelContainer* root = fileData->getContents<hkRootLevelContainer>();
    return root;
}

hkRootLevelContainer* hctSceneUtils::loadSceneFromFile( const char* filename, hkResource*& fileData  )
{
    fileData = HK_NULL;

    hkIstream is(filename);
    if( is.isOk() )
    {
        return loadSceneFromStream( *(is.getStreamReader()), fileData );
    }

    return HK_NULL;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
