// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Geometry/hkGeometry.h>

    /// This utility is used by the 3ds Max, Maya and XSI Physics tools in order to generate a convex hull
    /// representation of a given mesh with a specified maximum number of vertices.
    ///
    /// A good hull is searched for by removing random subsets of vertices such that the volume
    /// difference between the hulls of the reduced set and the original hull is as small as possible.
class hctCreateConvexHullUtil
{

public:

        /// The input structure to the utility
    struct Input
    {
            /// Constructor. Sets defaults.
        Input();

            /// The vertices of the original mesh.
        hkArray<hkVector4> m_vertices;

            /// User-specified maximum number of vertices in the 'coarse' hull
        int m_maxNumVerts;

            /// Force coarse hull to enclose all points
        hkBool  m_encloseInputs;

            // If not null, it will be called with progress information and it will be checked for early exit
        hctSdkUtils::ProgressUpdater* m_progressUpdater;
    };

        /// The ouput (result) data
    struct Output
    {
            /// The output geometry
            hkGeometry m_convexGeom;

            /// The percentage reduction of volume achieved (smaller is better - closer to the original hull)
            hkReal m_volumeReductionPercentage;
    };

        /// The main utility method.
    static hkResult createCoarseHull (const Input& input, Output& output);


private:


};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
