// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Common/SdkUtils/Geometry/hctCreateConvexHullUtil.h>

#include <Common/Internal/GeometryProcessing/ConvexHull/hkgpConvexHull.h>
#include <Common/Base/Types/Geometry/hkStridedVertices.h>

hctCreateConvexHullUtil::Input::Input()
{
    m_maxNumVerts = 64;
    m_encloseInputs = true;
    m_progressUpdater = HK_NULL;
}

hkResult hctCreateConvexHullUtil::createCoarseHull (const Input& input, Output& output)
{
    hkgpConvexHull  hull;
    if(hull.build(input.m_vertices)==3)
    {
        hull.buildMassProperties();
        const hkReal    orgVolume=hull.getVolume();
        hull.decimateVertices(input.m_maxNumVerts,input.m_encloseInputs);
        const hkReal    newVolume=hull.getVolume();
        output.m_volumeReductionPercentage  =   100-(newVolume*100)/orgVolume;
        hull.generateGeometry(hkgpConvexHull::SOURCE_VERTICES,output.m_convexGeom);
        return(HK_SUCCESS);
    }
    return(HK_FAILURE);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
