// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/Array/hkArray.h>

struct hkGeometry;

/// This utility provides functionality to optimize the constraints in a cloth data to produce better-behaved cloth.
class hctBonesFromMeshUtil
{
    public:
        enum BoneCreationMethod
        {
            CREATE_BONE_PER_VERTEX = 0,
            CREATE_BONE_PER_TRIANGLE,
            NUM_BONE_CREATION_METHODS
        };

        enum BoneAxis
        {
            B_X_AXIS = 0,
            B_Y_AXIS,
            B_Z_AXIS,
            B_NUM_AXIS
        };

        // Global Tangent Axis Types
        enum GlobalTangentAxis
        {
            GT_X_POSITIVE_AXIS = 0,
            GT_X_NEGATIVE_AXIS,
            GT_Y_POSITIVE_AXIS,
            GT_Y_NEGATIVE_AXIS,
            GT_Z_POSITIVE_AXIS,
            GT_Z_NEGATIVE_AXIS,
            GT_NUM_AXIS
        };


            /// Creates bones for a simulation mesh, returns true if bone transforms were correctly calculated
        static bool HK_CALL createBones (hkGeometry& simulationMesh, hkArray<hkTransform>& boneTransformsOut, BoneAxis normalAxis, BoneAxis tangentAxis, GlobalTangentAxis globalTangentAxis, hkArray<hkBool>& boneAxisChanged, BoneCreationMethod method=CREATE_BONE_PER_VERTEX);

    private:
        static void HK_CALL _calculateRotation(hkVector4 &boneNormalAxis, hkVector4 &boneTangentAxis, hkVector4& boneOtherAxis, BoneAxis normalAxis, BoneAxis tangentAxis, hkRotation& rotationOut);
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
