// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <string>
#include <vector>

#include <Common/Base/Container/String/Deprecated/hkStringOld.h>

class hctClassHierarchyUtil
{
    public:

        struct ParamGroup
        {
            public:

                struct ClassAndMember
                {
                    std::string          m_memberLabel;             // member's label in string form
                    std::string          m_memberInternalName;      // member's internal name in string form
                    std::string          m_defaultValue;            // member's default value in string form
                    const hkReflect::Type*  m_class;                    // the class the current member sits in
                    hkReflect::FieldDecl m_member;                  // the member information
                    hkBool               m_visible;                 // member's visibility flag
                    hkBool               m_editable;                // true if the member is editable
                };

            public:

                ParamGroup(const char* groupLabel, const char* groupInternalName)
                {
                    m_groupLabel        = groupLabel;
                    m_groupInternalName = groupInternalName;
                    m_visuallyEmpty     = false;
                }

                HK_INLINE void addChild(ParamGroup* child)
                {
                    m_subGroups.push_back(child);
                }

            public:

                const char* m_groupLabel;
                std::string m_groupInternalName;
                hkBool      m_visuallyEmpty;

                std::vector<ClassAndMember> m_members;
                std::vector<ParamGroup*>    m_subGroups;
        };

    public:

        static const char*                 getMemberName         (hkReflect::FieldDecl member, const hkUiAttribute* uiAttributes);

        static void createDisplayHierarchyFromClass(const hkReflect::Type* klass, std::string& groupPathDelimiter, hkReal unitConversionModifier, std::vector<hctClassHierarchyUtil::ParamGroup*>& groupsArrayOut);

        static void buildTreeFromClassDescription(const hkReflect::Type* klass, hkReflect::FieldDecl member, const std::string* namePrefix, const std::string groupPathDelimiter, hkReal unitConversionModifier, std::vector<ParamGroup*>& virtualRecursionStack, std::vector<ParamGroup*>& advancedGroupVirtualRecursionStack);

        static void pruneEmptyGroups(std::vector<ParamGroup*>& groupsArray);

        static void pruneInvisibleMembers(hkAttributeHideCriteria::Types modelerId, std::vector<ParamGroup*>& groupsArray);

        static void pruneMembersByClassType(const hkReflect::Type* type, std::vector<hctClassHierarchyUtil::ParamGroup*>& groupsArray);

        static void markVisuallyEmptyGroup(hkAttributeHideCriteria::Types modelerId, std::vector<ParamGroup*>& groupsArray);

        static void flattenHierarchy(ParamGroup* group, std::vector<ParamGroup*>& rootLevelArray);

        static bool isParentClassOf(const char* parentClassName, const hkReflect::Type* klass);

            /// This utility function will assert that the supplied string is "more than" C-style compliant, i.e., it will:
            /// - remove all non-alpha-numeric characters (by thus shortening the string)
            /// - make the first character lowercase
            /// - make sure the first character is a letter (and no digit)
        static void verifyAlphaNumericString(std::string& inputString);

    protected:

        static hkStringOld prettifyName(const char* nameIn);
        static void     getDefaultValueAsString(const ParamGroup::ClassAndMember& memberData, hkReal unitConversionModifier, std::string& defaultValueStringOut);
        static bool     pruneEmptyGroupsRecursively(ParamGroup* group);
        static void     pruneInvisibleMembersRecursively(hkAttributeHideCriteria::Types modelerId, ParamGroup* group);
        static void     pruneMembersByClassTypeRecursively(const hkReflect::Type* type, hctClassHierarchyUtil::ParamGroup* group);
        static void     markVisuallyEmptyGroupRecursively(hkAttributeHideCriteria::Types modelerId, ParamGroup* group);
        static void     mergeGroupsOfSameName(std::vector<hctClassHierarchyUtil::ParamGroup*>& groupsArray);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
