// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>
#include <Common/Base/Thread/Thread/hkThread.h>
#include <Common/Base/Thread/Semaphore/hkSemaphore.h>

struct hctCpuThreadPoolCinfo;
class hkWorkerThreadContext;
class hctFilterManagerInterface;


/// Construction info for hkctCpuThreadPoolCinfo
struct hctCpuThreadPoolCinfo : public hkCpuThreadPoolCinfo
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT, hctCpuThreadPoolCinfo);

    hctCpuThreadPoolCinfo();

public:

    /// The filter manager
    const hctFilterManagerInterface* m_filterMgr;
};


class hctCpuThreadPool : public hkCpuThreadPool
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        /// Initialize multi-threading state and create threads.
        hctCpuThreadPool(const hctCpuThreadPoolCinfo& cinfo);

    protected:

        virtual void threadMain(ThreadData* threadData) HK_OVERRIDE;

    protected:

        /// The filter manager
        const hctFilterManagerInterface* m_filterMgr;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
