// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Common/SdkUtils/Base/hctCpuThreadPool.h>

#include <ContentTools/Common/Filters/Common/FilterManager/hctFilterManagerInterface.h>

#include <Common/Base/Fwd/hkwindows.h>
#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Thread/Thread/hkWorkerThreadContext.h>
#include <Common/Base/Thread/TaskQueue/hkTaskQueue.h>

extern HK_EXPORT_COMMON HK_THREAD_LOCAL( int ) hkThreadNumber;


hctCpuThreadPoolCinfo::hctCpuThreadPoolCinfo()
{
    m_numThreads    = 1;
    m_threadName    = "HavokContentToolsWorkerThread";
    m_stackSize     = hkThread::HK_THREAD_DEFAULT_STACKSIZE;
    m_filterMgr     = HK_NULL;
}


hctCpuThreadPool::hctCpuThreadPool(const hctCpuThreadPoolCinfo& cinfo)
    : hkCpuThreadPool(cinfo, hkCpuThreadPool::START_THREADS_MANUALLY)
{
    m_filterMgr = cinfo.m_filterMgr;
    startThreads(cinfo);
}


void hctCpuThreadPool::threadMain(ThreadData* threadDataPtr)
{
    ThreadData& threadData = *threadDataPtr;

    // Flush all denormal/subnormal numbers (2^-1074 to 2^-1022) to zero.
    // Typically operations on denormals are very slow, up to 100 times slower than normal numbers.
#if defined(HK_COMPILER_HAS_INTRINSICS_IA32) && HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED
    _MM_SET_FLUSH_ZERO_MODE(_MM_FLUSH_ZERO_ON);
#endif

    // Initialize memory system
    hkMemorySystem& memorySystem = hkMemorySystem::getInstance();
    hkMemoryRouter memoryRouter;
    memorySystem.threadInit(memoryRouter, "hctCpuThreadPool::threadMain");

    if (m_filterMgr)
    {
        m_filterMgr->setThreadData(&memoryRouter);
    }
    else
    {
        hkBaseSystem::initThread(&memoryRouter);
    }

    // Store thread id in thread local memory
    HK_THREAD_LOCAL_SET(hkThreadNumber, threadData.m_threadId);

    threadData.m_timerData.m_streamBegin = hkMonitorStream::getInstance().getStart();
    threadData.m_timerData.m_streamEnd  = hkMonitorStream::getInstance().getEnd();

    hkCheckDeterminismUtil::initThread();

    threadData.m_thread.setIdealProcessor(threadData.m_hardwareThreadId);

    threadProcessingLoop(threadDataPtr, &memoryRouter);

    // Tear-down memory system and quit thread
    if (m_filterMgr)
    {
        m_filterMgr->setThreadData(HK_NULL);
    }
    hkBaseSystem::quitThread();
    hkMemorySystem::getInstance().threadQuit(memoryRouter);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
