// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hctFilterClassRegistry;

#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>

    /// Minor utilities used during export.
namespace hkSceneExportUtils
{
        /// Convert RGB and alpha float values to a single 32bit ARGB.
    inline unsigned floatsToARGB( const float r, const float g, const float b, const float a = 1.0f  )
    {
        return ((unsigned char)( a * 255.0f ) << 24 ) |
        ((unsigned char)( r * 255.0f ) << 16 ) |
        ((unsigned char)( g * 255.0f ) << 8 ) |
        ((unsigned char)( b * 255.0f ) );
    }

        /// Convert RGB and alpha float values to a single 32bit ARGB and set out-of-range colors to 80% grey full opaque
    inline unsigned floatsToARGB_grey( const float r, const float g, const float b, const float a = 1.0f  )
    {
        const float rr = (r >= 0.0f) ? ( (r <= 1.0f) ? r : 0.8f ) : 0.8f;
        const float gg = (g >= 0.0f) ? ( (g <= 1.0f) ? g : 0.8f ) : 0.8f;
        const float bb = (b >= 0.0f) ? ( (b <= 1.0f) ? b : 0.8f ) : 0.8f;
        const float aa = (a >= 0.0f) ? ( (a <= 1.0f) ? a : 1.0f ) : 1.0f;
        return ((unsigned char)( aa * 255.0f ) << 24 ) |
            ((unsigned char)( rr * 255.0f ) << 16 ) |
            ((unsigned char)( gg * 255.0f ) << 8 ) |
            ((unsigned char)( bb * 255.0f ) );
    }

        /// Convert RGB and alpha float values to a single 32bit ARGB and saturate out-of-range colors while making full opaque
    inline unsigned floatsToARGB_saturate( const float r, const float g, const float b, const float a = 1.0f  )
    {
        const float rr = (r >= 0.0f) ? ( (r <= 1.0f) ? r : 1.0f ) : 0.0f;
        const float gg = (g >= 0.0f) ? ( (g <= 1.0f) ? g : 1.0f ) : 0.0f;
        const float bb = (b >= 0.0f) ? ( (b <= 1.0f) ? b : 1.0f ) : 0.0f;
        const float aa = (a >= 0.0f) ? ( (a <= 1.0f) ? a : 1.0f ) : 1.0f;
        return ((unsigned char)( aa * 255.0f ) << 24 ) |
            ((unsigned char)( rr * 255.0f ) << 16 ) |
            ((unsigned char)( gg * 255.0f ) << 8 ) |
            ((unsigned char)( bb * 255.0f ) );
    }

        /// Replaces any "<" and ">" character with underscores so the name can be part of an XML file.
    inline void getSerializableName( const char* nodeName, hkStringOld& newName )
    {
        newName = nodeName;
        newName = newName.replace('<', '_'); // no xml tag parts
        newName = newName.replace('>', '_');
    }

        /// As getSerializableName, but also replacing spaces with underscores.
    inline void getReducedName( const char* nodeName, hkStringOld& newName )
    {
        getSerializableName(nodeName, newName);
        newName = newName.replace(' ', '_'); // no spaces
    }

    inline void reportSceneData (const hkxScene* scene)
    {
        const int totalNodes = scene->m_rootNode ? (1 + scene->m_rootNode->getNumDescendants()) : 0;

        HK_REPORT2 (0xabba1441, "Exported "<<totalNodes<<" nodes, "<<scene->m_selectionSets.getSize() <<" node selection sets, "
            <<scene->m_materials.getSize() <<" materials, " <<scene->m_meshes.getSize() <<" meshes, "
            <<scene->m_lights.getSize() <<" lights, "<< scene->m_cameras.getSize() <<" cameras, "<<scene->m_skinBindings.getSize() <<" skin bindings.");
    }

    template<typename T>
    inline void sortAndRemoveDuplicates(hkArray<T>& array)
    {
        hkSort(array.begin(), array.getSize());
        for (hkInt32 idx = 1; idx < array.getSize();)
        {
            if (array[idx] == array[idx - 1])
            {
                array.removeAtAndCopy(idx);
            }
            else
            {
                ++idx;
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
