// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>


class hkSceneExportMemThreadCallback
{
public:
        /// Null on thread delete
    virtual void initThread( hkMemoryRouter* m_memoryRouter ) = 0;
};

class hkDefaultSceneExportMemThreadCallback : public hkSceneExportMemThreadCallback
{
public:
    virtual void initThread( hkMemoryRouter* m_memoryRouter );
};

    /// Functions in this namespace are used to initialize thread memory as well as to retrieve information
    /// about singletons.
namespace hkSceneExportMemory
{
        /// Initialized Havok's base system using thread-safe memory
    void HK_CALL baseSystemInit(bool debugMem = false);

        /// Quits Havok's bases system
    void HK_CALL baseSystemQuit();

        /// Retrieves information about the singletons used by this module (DLL or EXE)
    void HK_CALL getBaseSystemSyncInfo( hkMemoryInitUtil::SyncInfo& baseSystemInfo );

    static hkDefaultSceneExportMemThreadCallback g_defaultThreadCallback;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
