// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/SceneExport/hctSceneExport.h> // PCH
#include <ContentTools/Common/SceneExport/Memory/hctSceneExportMemory.h>
#include <Common/Base/System/Error/hkDefaultError.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Fwd/hkcstdio.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>


static void _errorReportFunction(const char* buf, void *obj)
{
    // just output to the debug stream and try to carry on..
    OutputDebugString( buf );
}

void hkDefaultSceneExportMemThreadCallback::initThread( hkMemoryRouter* memoryRouter )
{
    if ( memoryRouter )
    {
        hkBaseSystem::initThread( memoryRouter );
    }
    else
    {
        hkBaseSystem::quitThread();
    }
}

#ifdef HK_DEBUG_SLOW
#   define FORCE_DEBUG_MEMORY true
#else
#   define FORCE_DEBUG_MEMORY false
#endif

void hkSceneExportMemory::baseSystemInit(bool debugMem)
{
    // Initialize the base system
    hkMemoryRouter* memoryRouter = (debugMem || FORCE_DEBUG_MEMORY )
        ? hkMemoryInitUtil::initChecking(hkMallocAllocator::m_defaultMallocAllocator, hkMemorySystem::FrameInfo(6 * 1024 * 1024))
        : hkMemoryInitUtil::initFreeListLargeBlock(hkMallocAllocator::m_defaultMallocAllocator, hkMemorySystem::FrameInfo(6 * 1024 * 1024));
    hkBaseSystem::init( memoryRouter, _errorReportFunction );

    // These asserts are no longer useful - we're using a fake scratchpad.
    hkError::getInstance().setEnabled( 0x20ad62c3, false );
    hkError::getInstance().setEnabled( 0x651498c4, false );
    hkError::getInstance().setEnabled( 0xF3768206, false ); // pushBack on serialized array.
}

void hkSceneExportMemory::baseSystemQuit()
{
    hkBaseSystem::quit();
    hkMemoryInitUtil::quit();
}

void hkSceneExportMemory::getBaseSystemSyncInfo( hkMemoryInitUtil::SyncInfo& si )
{
    hkMemoryInitUtil::SyncInfo::getLocalInfo(si);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
