// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


///
/// This utility class provides a modeler-independent way to build a modeler mesh/node from a Havok mesh.
///
class hctModelerMeshBuilderUtilities
{
    public:

        /// Locks the required sections from the mesh. Prunes all sections from the set that don't contain triangle information.
        /// Returns the number of 'triangle' sections available in the pruned set (can be 0 if none available/left).
        static int HK_CALL prepareMeshSectionLockSet(const hkMeshBody& meshBody, hkMeshSectionLockSet* lockSet);

        /// Converts the given Havok mesh into modeler mesh/node. Requires the lock set to be processed by prepareMeshSectionLockSet() first.
        static hkResult HK_CALL convertHavokMeshToModelerNode(const hkMeshBody& meshBody, const hkMeshSectionLockSet& lockSet, hctModelerMeshBuilder& modelerMeshBuilder);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
