// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

    /// An error handler which stores all messages in a log, and allows merging
    /// of the contents of two handlers logs. Extended by the filter manager and
    /// by the individual scene exporters.
class hctSceneExportError : public hkError
{
public:

    hctSceneExportError() : m_indent(0), m_ignoreAll(false), m_criticalSection(1000) {}
    virtual ~hctSceneExportError() {}

        // hkError interface implementation

    virtual int message(Message type, int id, const char* description, const char* file, int line);

    virtual void    setEnabled( int id, hkBool enabled );
    virtual hkBool  isEnabled( int id );
    virtual void    enableAll();

    virtual void sectionBegin(int id, const char* sectionName);
    virtual void sectionEnd();

        /// Merge the 'log' of another handler with this one
    void merge( const hctSceneExportError* otherHandler );

    void clearLog();
    virtual void setLogFile( const char* logFileName ) {}
    virtual void setLogVerboseLevel( unsigned int logVerboseLevel ) {}
    virtual void setStdOutput( bool output ) {}

        /// Structure which represents an entry in the log
    struct LogEntry
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_EXPORT, LogEntry );
        Message     m_type;
        int         m_id;
        hkStringOld m_text;
        bool        m_customColor;
        COLORREF    m_color;

        LogEntry(Message type, int id, const char* desc, const char* file, int line);
    };

    int numLogEntries() const;
    const LogEntry& getLogEntry(int i) const;

    /// Merge the specified log entry into this one.
    void mergeLogEntry(const LogEntry& logEntry);

protected:

    hkPointerMap<int, int>  m_disabledAssertIds;
    hkCriticalSection m_criticalSection;
    hkArray<LogEntry> m_log;
    int m_indent;
    bool m_ignoreAll;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
