// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/SceneExport/hctSceneExport.h> // PCH
#include <ContentTools/Common/SceneExport/Error/hctSceneExportError.h>

#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

int hctSceneExportError::message(Message type, int id, const char* description, const char* file, int line)
{
    if ( m_ignoreAll )
    {
        return 0;
    }

    // Skip disabled ids
    if( !isEnabled(id) )
    {
        return 0;
    }

    // Create the new log entry
    LogEntry entry( type, id, description, file, line );

    hkStringBuf indented;
    // Prefix with the current indent
    for( int i=0; i<m_indent; ++i )
    {
        indented.append("    ");
    }
    indented.append(entry.m_text.cString());
    entry.m_text = indented.cString();

    // Store the entry
    m_criticalSection.enter();
    m_log.pushBack( entry );
    m_criticalSection.leave();

    return 0; // COM-654, EXP-1706, EXP-1684 - We don't want a breakpoint in tools as it will crash stuff. Better to try to continue.
}


void hctSceneExportError::setEnabled( int id, hkBool enabled )
{
    // you can use -1 to temporarily ignore all errors
    if ( id == -1 )
    {
        m_ignoreAll = !enabled;
        return;
    }

    if( enabled )
    {
        m_disabledAssertIds.remove(id);
    }
    else
    {
        m_disabledAssertIds.insert(id, 1);
    }
}

hkBool hctSceneExportError::isEnabled( int id )
{
    return m_disabledAssertIds.getWithDefault(id, 0) == 0;
}

void hctSceneExportError::enableAll()
{
    m_disabledAssertIds.clear();
    m_ignoreAll = false;
}


void hctSceneExportError::sectionBegin(int id, const char* desc)
{
    char buf[1024];
    {
        hkOstream os(buf, sizeof(buf), true);
        os << "[ " << desc << " ]";
    }

    message( MESSAGE_REPORT, 0, buf, 0, 0 );
    m_indent++;
}

void hctSceneExportError::sectionEnd()
{
    m_indent--;
}


void hctSceneExportError::merge( const hctSceneExportError* otherHandler )
{
    if( otherHandler )
    {
        for( int i=0; i<otherHandler->m_log.getSize(); ++i )
        {
            m_log.pushBack( otherHandler->m_log[i] );
        }
    }
}


void hctSceneExportError::clearLog()
{
    m_log.clear();
}


int hctSceneExportError::numLogEntries() const
{
    return m_log.getSize();
}


const hctSceneExportError::LogEntry& hctSceneExportError::getLogEntry(int i) const
{
    return m_log[i];
}


void hctSceneExportError::mergeLogEntry(const LogEntry& logEntry)
{
    m_log.pushBack(logEntry);
}


hctSceneExportError::LogEntry::LogEntry(hkError::Message type, int id, const char* desc, const char* file, int line) :
    m_customColor(false),
    m_color(RGB(0,0,0))
{
    m_type = type;
    m_id   = id;

    hkStringOld messageStr;
    switch( type )
    {
    case MESSAGE_REPORT:
        m_text = desc;
        return;
    case MESSAGE_WARNING:
        messageStr = "Warning";
        break;
    case MESSAGE_ASSERT:
        messageStr = "Assert";
        break;
    case MESSAGE_ERROR:
        messageStr = "Fatal Error";
        break;
    }

    m_text.printf( "[0x%x] %s : %s", id, messageStr.cString(), desc );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
