// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <ContentTools/Common/SceneExport/AttributeSelection/hctAttributeSelection.h>

    /// This class loads user-defined attribute selection files and provides the exporters with utilities to
    /// filter attributes based on the user selections
class hctAttributeSelectionUtil
{
    public:

        ~hctAttributeSelectionUtil();

            /// Initializes an instance of this class. Usually a single instance is used to select attributes before export.
        hkBool init ();

            /// Loads all attribute descriptions in the given path.
        hkBool loadAttributeSelections(const char* attributeSelectionPath );

            /// Returned by "filterAttribute", it specifies the user's desire regarding that attribute.
        enum UserAction
        {
                /// The attribute should be exported
            USER_ADD,

                /// The attribute should not be exported
            USER_REMOVE,

                /// No user-specified behaviour
            USER_UNDEFINED,
        };

            /// Returns what was the choice of the user for the given attribute/attribute holder can possibly be selected for export.
            /// Matches will be checked for all the non-null values.
        UserAction filterAttribute (const char* typeName, const char* subTypeName = HK_NULL, const char* attributeName = HK_NULL) const;

    private:

        hctAttributeSelectionDatabase m_database;

        /*
        ** Merging
        */
        void mergeAttributeSelectionDatabase (hctAttributeSelectionDatabase& newDatabase);

        // Reused for each othe addition/removal arrays
        void mergeAttributeSelectionArray (hkArray<hctAttributeSelection>& currentArray, hkArray<hctAttributeSelection>& newArray);

        /*
        ** Matching
        */

        hkBool matchAttributeSelection (const char* typeName, const char* subTypeName, const char* attributeName, const hctAttributeSelection& selection ) const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
