// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/SceneExport/hctSceneExport.h> // PCH
#include <ContentTools/Common/SceneExport/AttributeSelection/hctAttributeSelectionUtil.h>
#include <ContentTools/Common/SceneExport/AttributeProcessing/hctAttributeDescription.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/Container/String/hkUtf8.h>

#include <Common/Base/Config/hkConfigVersion.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>

hkBool hctAttributeSelectionUtil::init ()
{

    m_database.m_attributeAdditions.clear();

    m_database.m_attributeRemovals.clear();

    return true;
}

hctAttributeSelectionUtil::~hctAttributeSelectionUtil()
{
}

hkBool hctAttributeSelectionUtil::loadAttributeSelections( const char* attributeSelectionPath )
{
    WIN32_FIND_DATA FindFileData;
    HANDLE hFindHandle;
    hkStringOld databasePath = attributeSelectionPath ;
    databasePath += "\\hct*.xml";
    hFindHandle = FindFirstFile( TEXT( databasePath.cString() ), &FindFileData);
    bool finished = (hFindHandle == INVALID_HANDLE_VALUE);
    while( !finished )
    {
        hkStringOld xmlName = attributeSelectionPath;
        xmlName += "\\";
        xmlName += FindFileData.cFileName;

        hkIstream file(xmlName.cString());
        if (file.isOk())
        {
            hkRefPtr<hkResource> loaded;
            // Suppress warnings about signature mismatch on hkClass caused by old XML files.
            hkError::getInstance().setEnabled(0x7bfbc4c0, false);
            hkError::getInstance().setEnabled(0x741cc3a5, false);
            loaded = hkSerialize::Load().toResource(file.getStreamReader());
            hkError::getInstance().setEnabled(0x7bfbc4c0, true);
            hkError::getInstance().setEnabled(0x741cc3a5, true);

            if (loaded)
            {
                if (hctAttributeSelectionDatabase* db = loaded->getContents<hctAttributeSelectionDatabase>())
                {
                    mergeAttributeSelectionDatabase(*db);
                }
            }
        }

        // get next xml file:
        if (FindNextFile( hFindHandle, &FindFileData ) == 0) // zero == error
        {
            finished = true;
            FindClose(hFindHandle);
        }
    }

    return true;
}

void hctAttributeSelectionUtil::mergeAttributeSelectionDatabase (hctAttributeSelectionDatabase& newDatabase)
{
    // Merge additions array
    mergeAttributeSelectionArray (  m_database.m_attributeAdditions, newDatabase.m_attributeAdditions );

    // Merge removalss array
    mergeAttributeSelectionArray (  m_database.m_attributeRemovals, newDatabase.m_attributeRemovals );
}

void hctAttributeSelectionUtil::mergeAttributeSelectionArray (hkArray<hctAttributeSelection>& currentArray, hkArray<hctAttributeSelection>& newArray)
{
    for (int i = 0; i < newArray.getSize(); ++i)
    {
        currentArray.expandOne().move(newArray[i]);
    }
}

static bool _stringMatch (const char* pattern, const char* string)
{
    hkStringOld patternStr(pattern); patternStr = patternStr.asLowerCase();
    hkStringOld userStr(string); userStr = userStr.asLowerCase();

    for (int ci=0; ci<userStr.getLength(); ci++)
    {
        if (ci>=patternStr.getLength()) return false;

        if (patternStr[ci]=='*') return true;

        if (patternStr[ci]!=userStr[ci]) return false;
    }

    // case of "blah*" and "blah" -> true
    if ((patternStr.getLength()==userStr.getLength()+1) && (patternStr[userStr.getLength()]=='*'))
    {
        return true;
    }

    // Different lengths -> false
    if (patternStr.getLength()!=userStr.getLength())
    {
        return false;
    }

    return true;
}

hkBool hctAttributeSelectionUtil::matchAttributeSelection (const char* typeName, const char* subTypeName, const char* attributeName, const hctAttributeSelection& selection ) const
{
    if (typeName && !_stringMatch(selection.m_typeName, typeName))
    {
        return false;
    }

    if (subTypeName && !_stringMatch(selection.m_subTypeName, subTypeName))
    {
        return false;
    }

    if (attributeName)
    {
        bool match = false;
        for (int ai=0; ai<selection.m_attributeNames.getSize(); ai++)
        {
            if (_stringMatch(selection.m_attributeNames[ai], attributeName))
            {
                match = true;
                break;
            }
        }

        if (!match) return false;
    }

    // We matched everything
    return true;
}

hctAttributeSelectionUtil::UserAction hctAttributeSelectionUtil::filterAttribute (const char* typeName, const char* subTypeName, const char* attributeName) const
{
    UserAction result = USER_UNDEFINED;

    // Additions
    for (int i=0; i<m_database.m_attributeAdditions.getSize(); i++)
    {
        const hctAttributeSelection& userSelection = m_database.m_attributeAdditions[i];

        if (matchAttributeSelection(typeName, subTypeName, attributeName, userSelection))
        {
            result = USER_ADD;
            break;
        }
    }

    // Removals - take precedence over additions so they are processed after
    for (int i=0; i<m_database.m_attributeRemovals.getSize(); i++)
    {
        const hctAttributeSelection& userSelection = m_database.m_attributeRemovals[i];

        // For removals, we only want to return USER_REMOVE for NULL entries if we match all entries
        const char* rTypeName = typeName ? typeName : "*";
        const char* rSubtTypeName = subTypeName ? subTypeName : "*";
        const char* rAttrName = attributeName ? attributeName : "*";

        if (matchAttributeSelection(rTypeName, rSubtTypeName, rAttrName, userSelection))
        {
            result = USER_REMOVE;
            break;
        }
    }

    return result;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
