// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// An hctAttributeSelectionDatabase represents a table of entries (attribute selection) specifying sets of attributes that
/// the user wants a scene exporter to sample and export.
struct hctAttributeSelectionDatabase
{
    HK_DECLARE_CLASS( hctAttributeSelectionDatabase, New, Reflect );

        /// The array of attribute selections (additions)
    hkArray<struct hctAttributeSelection> m_attributeAdditions;

    /// The array of attribute selections (removals)
    hkArray<struct hctAttributeSelection> m_attributeRemovals;
};

/// An hctAttributeSelection contains an entry specifying a user selection of one or multiple attributes inside particular
/// node/parameter block/property. The "*" character can be used as a wildcard for any of the strings.
/// The interpretation of each field is specific to the individual modeller - check the Havok
/// Content Tools documentation (integration section) for details.
struct hctAttributeSelection
{
    HK_DECLARE_CLASS( hctAttributeSelection, New, Reflect );

        /// The typename is the higher-level name of the modeller entity that holds the attribute. This is different for each modeller.
    hkStringPtr m_typeName;

        /// Some modelers have two levels of containment of attributes, and use this "subTypeName" value.
    hkStringPtr m_subTypeName;

        /// A list of attribute names. Wildcards can be used here as well.
    hkArray<hkStringPtr> m_attributeNames;

    void move(hctAttributeSelection& rhs);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
