// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Graph/hkxNode.h>

#include <Common/SceneData/Attributes/hkxAttribute.h>

#include <ContentTools/Common/SceneExport/AttributeProcessing/hctAttributeDescription.h>

    /// An instance of this class can be used to handle the manipulation of attributes before export (the transformation
    /// of attributes based on hctAttributeDescription objects).
class hctAttributeProcessingUtil
{
    public:

            /// Initializes an instance of this class. Usually a single instance is used to process all attributes before export.
        hkBool init ();

            /// Loads all attribute descriptions in the given path.
        hkBool loadAttributeDescriptions(const char* attributeDescriptionPath );

            /// Given an attribute holder (node/material), it merges attribute groups with the same name and then processes each group,
            /// following the instructions in the attribute descriptions stored in the database.
        void processAttributes (hkxAttributeHolder* attributeHolder);

            /// Given two attribute groups, merges them into a third one.
        void mergeTwoAttributeGroups(const hkxAttributeGroup& groupOne, const hkxAttributeGroup& groupTwo, hkxAttributeGroup& mergedGroup);

            /// Returns true if no valid attribute description data has been loaded yet.
        hkBool isEmpty () const;

            /// Destructor, frees up allocated memory.
        ~hctAttributeProcessingUtil();

    private:

        hctAttributeDescriptionDatabase m_database;

        hkPointerMap<const hctAttributeDescription::Enum*, hkxEnum*> m_enumMap;

    private:

        // Given an attribute group, it processes the attributes inside it, following the instructions in the attribute description.
        void processAttributeGroup (hkxAttributeGroup& attrGroup);

        // Merging (EXP-497)
        void mergeAttributeDescriptionDatabase (hctAttributeDescriptionDatabase& newDatabase);
        void mergeAttributeGroupDescriptions (hctAttributeGroupDescription& newGroupDesc, hctAttributeGroupDescription& currentGroupDesc);
        void mergeAttributeDescriptions(hctAttributeDescription& newAttDesc, hctAttributeDescription& currentAttDesc);

        void mergeXYZToVector (hkArray<hkxAttribute>& attributes);
        void scaleFloats (hkArray<hkxAttribute>& attributes, const struct hctAttributeGroupDescription* attrGroupDesc);
        void mergeTransAndRotToMatrix (hkArray<hkxAttribute>& attributes);
        void enforceTypes (hkArray<hkxAttribute>& attributes, const struct hctAttributeGroupDescription* attrGroupDesc);
        void enforceChangePairs (hkArray<hkxAttribute>& attributes);
        void enforceEnabledBy (hkArray<hkxAttribute>& attributes, const struct hctAttributeGroupDescription* attrGroupDesc);
        void enforceHints (hkArray<hkxAttribute>& attributes, const struct hctAttributeGroupDescription* attrGroupDesc);

        // Supported attribute conversions
        class hkxAnimatedQuaternion* convertEulerToQuaternion (class hkxAnimatedVector* animatedVector);
        class hkxAnimatedQuaternion* convertMatrixToQuaternion (class hkxAnimatedMatrix* animatedMatrix);
        class hkxSparselyAnimatedEnum* convertIntToEnum (class hkxSparselyAnimatedInt* animatedInt, class hkxEnum* enumClass);
        class hkxSparselyAnimatedString* convertIntToString (class hkxSparselyAnimatedInt* animatedInt, const class hkxEnum* enumClass);
        class hkxSparselyAnimatedString* convertEnumToString (class hkxSparselyAnimatedEnum* animatedEnum);

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
