// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/SceneExport/hctSceneExport.h> // PCH
#include <ContentTools/Common/SceneExport/AttributeProcessing/hctAttributeDescription.h>
#include <Common/Base/Fwd/hkutility.h>


// Constructor, sets defaults.
hctAttributeDescription::hctAttributeDescription()
:
    m_name (HK_NULL),
    m_forcedType (LEAVE),
    m_enum (HK_NULL),
    m_hint (HINT_NONE),
    m_floatScale (1.0f),
    m_clearHints (false)
{
}

void hctAttributeDescription::move(hctAttributeDescription& rhs)
{
    m_name = hk::move(rhs.m_name);
    m_enabledBy = rhs.m_enabledBy;
    m_forcedType = rhs.m_forcedType;
    m_enum.reset(rhs.m_enum.steal());
    m_hint = rhs.m_hint;
    m_clearHints = rhs.m_clearHints;
    m_floatScale = rhs.m_floatScale;
}

const hctAttributeDescription* hctAttributeGroupDescription::findAttributeDescriptionByName(const char* name) const
{
    for (int a=0; a < m_attributeDescriptions.getSize(); ++a)
    {
        if ( m_attributeDescriptions[a].m_name && (hkString::strCasecmp(m_attributeDescriptions[a].m_name, name)==0) )
        {
            return &m_attributeDescriptions[a];
        }
    }
    return HK_NULL;
}

void hctAttributeGroupDescription::move(hctAttributeGroupDescription& rhs)
{
    m_name = hk::move(rhs.m_name);
    
    m_attributeDescriptions.swap(rhs.m_attributeDescriptions);
}

const hctAttributeGroupDescription* hctAttributeDescriptionDatabase::findAttributeDescriptionGroupByName(const char* name) const
{
    for (int i=0; i < m_groupDescriptions.getSize(); ++i)
    {
        const hctAttributeGroupDescription& desc = m_groupDescriptions[i];
        if (hkString::strCasecmp(desc.m_name, name)==0)
        {
            return &desc;
        }
    }

    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
