// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterViewXml/hctFilterViewXml.h>
#include <ContentTools/Common/Filters/FilterViewXml/hctFilterViewXmlDll.h>
#include <Common/Base/System/Error/hkDefaultError.h>

// Filters we want to expose in this dll:
#include <ContentTools/Common/Filters/FilterViewXml/ViewXml/hctViewXmlFilter.h>

#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
//#define HK_CLASSES_FILE <Common/SceneData/Classes/hkSceneDataClasses.h> //todo.nt4
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#include <Common/Base/Config/hkProductFeatures.cxx>


__declspec( dllexport ) hctFilterDll* getFilterDll (HMODULE dllModule)
{
    static hctFilterViewXmlDll gFilterViewXmlDll (dllModule);

    return &gFilterViewXmlDll;
}

hctFilterViewXmlDll::hctFilterViewXmlDll (HMODULE dllModule) :
    hctModelessFilterDll (dllModule)
{

}

/*virtual*/ int hctFilterViewXmlDll::getNumberOfFilters() const
{
    return 1;
}

/*virtual*/ hctFilterDescriptor* hctFilterViewXmlDll::getFilterDescriptor (int index) const
{
    static hctFilterDescriptor* m_filterDescs[] =
    {
        &g_viewXmlDesc,
    };

    return m_filterDescs[index];
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
