// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterViewXml/hctFilterViewXml.h>
#include <ContentTools/Common/Filters/FilterViewXml/ViewXml/hctViewXmlFilter.h>

extern HINSTANCE hInstance;

INT_PTR CALLBACK _viewXmlOptionsDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    // We store a pointer to the filter associated with this dialog using Get/SetWindowLongPtr()
    hctViewXmlFilter* filter = reinterpret_cast<hctViewXmlFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
    case WM_INITDIALOG:
        {
            filter = (hctViewXmlFilter*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            CheckDlgButton(hWnd, IDC_CB_ExecuteModally, filter->m_options.m_executeModally);

            // Initialize Tool Tips
            {
                CreateToolTip(IDC_CB_ExecuteModally, hWnd, hInstance, "If enabled, this option will make the View XML operate modally; that is, processing will be halted until the View XML window is closed.");
            }

            return TRUE; // did handle it
        }
    }
    return FALSE; //didn't handle it
}

void hctViewXmlFilter::updateOptions()
{
    // Ensure the options we store match the options shown in the UI
    if (m_optionsDialog)
    {
        m_options.m_executeModally = IsDlgButtonChecked(m_optionsDialog, IDC_CB_ExecuteModally) == TRUE;
    }
}


HWND hctViewXmlFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
    {
        hideOptions();
    }

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_VIEW_XML_DIALOG),
        owner, _viewXmlOptionsDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctViewXmlFilter::hideOptions()
{
    // Update any changes before we close UI
    updateOptions();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;

}

void hctViewXmlFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctViewXmlOptions* options = hctFilterUtils::getNativeOptions<hctViewXmlOptions>(optVar))
    {
        m_options = *options;
        delete options;
    }
}

void hctViewXmlFilter::getOptions(hkReflect::Any& buffer) const
{
    buffer.setFromObj( m_options );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
