// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterTutorial/hctFilterTutorial.h>

#include <ContentTools/Common/Filters/FilterTutorial/ConvertToPhantomAction/hctConvertToPhantomActionFilter.h>

extern HINSTANCE hInstance;

INT_PTR CALLBACK _convertToPhantomActionDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    // We store a pointer to the filter associated with this dialog using Get/SetWindowLongPtr()
    hctConvertToPhantomActionFilter* filter = reinterpret_cast<hctConvertToPhantomActionFilter*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch(message)
    {
        case WM_INITDIALOG:
            {
                filter = (hctConvertToPhantomActionFilter*)lParam;
                SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

                CheckDlgButton(hWnd, IDC_CB_RemoveMeshes, filter->m_options.m_removeMeshes);

                // Initialize Tool Tips
                {
                    CreateToolTip(IDC_CB_RemoveMeshes, hWnd, hInstance, "If enabled, this option will remove the association of a rigid body node to its original mesh whenever it is converted to a phantom (so the phantom won't be displayed by the preview scene filter).");
                }

                return TRUE; // did handle it
            }
    }
    return FALSE; //didn't handle it
}

void hctConvertToPhantomActionFilter::updateOptions()
{
    // Ensure the options we store match the options shown in the UI
    if (m_optionsDialog)
    {
        m_options.m_removeMeshes = IsDlgButtonChecked(m_optionsDialog, IDC_CB_RemoveMeshes) == TRUE;
    }
}


HWND hctConvertToPhantomActionFilter::showOptions(HWND owner)
{
    if (m_optionsDialog)
    {
        hideOptions();
    }

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_CONVERT_TO_PHANTOM_ACTION_DIALOG),
        owner, _convertToPhantomActionDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctConvertToPhantomActionFilter::hideOptions()
{
    // Update any changes before we close UI
    updateOptions();

    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }

    m_optionsDialog = NULL;

}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
