// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 REFLECT
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Misc/PhantomCallback/hkpPhantomCallbackShape.h>

// Our phantom call back shape will be notified when an object enters or exits the shape
// We use those event to dynamically add / remove an action.
class MyPhantomShape : public hkpPhantomCallbackShape
{
    public:

        HK_DECLARE_CLASS(MyPhantomShape, New, Reflect);

        MyPhantomShape();
        ~MyPhantomShape() {};

        // hkpPhantom interface implementation
        void phantomEnterEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl, const hkpCollisionInput& env );
        void phantomLeaveEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl );

    public:

        enum ActionType
        {
            ACTION_WIND,
            ACTION_ATTRACT,
            ACTION_DEFLECT
        };

        hkEnum<ActionType, hkInt8> m_actionType;
        hkVector4 m_direction;
        hkReal m_strength;
};

HK_REFLECT_ENUM(/**/, MyPhantomShape::ActionType);

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
