// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Filters/FilterTool/hctFilterToolStub.h>

#pragma unmanaged

// Windows.h, hkbase etc:
#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

#include <Filters/FilterTool/hctFilterToolStubDll.h>
#include <Filters/FilterTool/Inline/hctFilterToolStubImpl.h>

#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#define HK_CLASSES_FILE <ContentTools/Common/Filters/FilterTool/_Auto/hctFilterToolClassList.cxx>
#include <Common/Base/Config/hkProductFeatures.cxx>


// DLL main
HINSTANCE hInstance;
static BOOL ExtraStaticsInitialized = FALSE;
CRITICAL_SECTION __g_threadListCriticalSection;

BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved)
{
    switch ( fdwReason )
    {
    case DLL_PROCESS_ATTACH:
        {
            hInstance = hinstDLL;               // Hang on to this DLL's instance handle.
            InitializeCriticalSectionAndSpinCount( &__g_threadListCriticalSection, 1000 ); \

            if (!ExtraStaticsInitialized) {

                ExtraStaticsInitialized = TRUE;

                // CK:
                // The IJW compiler just doesn't like this pure virtual, unmanaged, global static
                // and always gives it a null vtable.. so I just new it explicitly here to avoid the issue
                // so the compiler / dll load does not have to make the obj automatically.
                //
                g_stubToolFilterDesc = new hctFilterToolStubImplDesc();
            }
            break;
        }

    case DLL_PROCESS_DETACH:
        {
            DeleteCriticalSection( &__g_threadListCriticalSection ); \

            if (ExtraStaticsInitialized)
            {
                ExtraStaticsInitialized = FALSE;

                delete g_stubToolFilterDesc;
                g_stubToolFilterDesc = NULL;

            }
        }

    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
        break;
    }
    return TRUE;
}



__declspec( dllexport ) hctFilterDll* __cdecl getFilterDll (HMODULE dllModule)
{
    static ToolsFilterStubDll gFilterStubDll(dllModule);
    return &gFilterStubDll;
}



ToolsFilterStubDll::ToolsFilterStubDll (HMODULE dllModule) : hctModelessFilterDll (dllModule)
{
}


#pragma managed(push, on)
void InitAppDomain() {}
#pragma managed(pop)

/*virtual*/ void ToolsFilterStubDll::initDll(const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream)
{
    // Static data in a mixed DLL is initialized only on AppDomain initialization.
    // TypeRegNodes must be initialized before they are added to the registry,
    // so we call a dummy managed function here to trigger the initialization explicitly.
    InitAppDomain();
    hctModelessFilterDll::initDll(baseSystemInfo, errorStream);
}

/*virtual*/ int ToolsFilterStubDll::getNumberOfFilters() const
{
    return 1;
}



/*virtual*/ hctFilterDescriptor* ToolsFilterStubDll::getFilterDescriptor (int index) const
{
    return g_stubToolFilterDesc;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
