// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Filters/FilterTool/hctFilterToolStub.h>

#pragma unmanaged
#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>
#include <ContentTools/Common/Tool/ToolInterfaces/ToolInterfaceMacros.h>
#include <Filters/FilterTool/Inline/hctFilterToolStubImpl.h>

#pragma managed

using namespace System;
using namespace System::Windows::Forms;
using namespace Havok;
using namespace Havok::Tool;
using namespace System::Resources;

//
//  Create a window and init the HavokUI C# ctrl to use it
//

public ref class FilterMainForm : public Form
{
public:

    FilterMainForm(String^ renderer)
    {
        havokUI = nullptr;
        components = nullptr;

        ResourceManager^ resManager = gcnew ResourceManager( "hctFilterToolStub.hctFilterToolStubImplManaged", this->GetType()->Assembly );
        if (resManager != nullptr)
        {
            //xx this->Icon = (Drawing::Icon^) resManager->GetObject( "HavokLogo");
        }

        InitializeComponent();
        InitializeHavokCtrl(renderer);
    }

    ~FilterMainForm()
    {
        if (components)
        {
            delete components;

            delete havokUI;
            havokUI = nullptr;
        }
    }

    void InitializeHavokCtrl(String^ renderer)
    {
        SuspendLayout();

        IntPtr baseInfo(0);
        HAVOK_TOOLS_BASE_SYSTEM_GET_INFO(baseInfo);

        havokUI = gcnew Havok::Tool::ToolUI(renderer, baseInfo);
        havokUI->Dock = System::Windows::Forms::DockStyle::Fill;
        havokUI->Location = System::Drawing::Point(0, 0);
        havokUI->Name = "ui";
        havokUI->Size = System::Drawing::Size(1079, 654);
        havokUI->TabIndex = 0;

        this->Controls->Add(havokUI);

        ResumeLayout(true);
    }

    void MainForm_Shown( Object^ sender, EventArgs^ e )
    {
        havokUI->CloseSplashScreen();
    }

    void InitializeComponent()
    {
        this->ClientSize = System::Drawing::Size(1079, 656);
        this->Name = "MainForm";
        this->Text = "Havok Preview Tool [Filter I/F]";
        this->Shown += gcnew System::EventHandler( this, &FilterMainForm::MainForm_Shown);

    }

public:

    Havok::Tool::ToolUI^ havokUI;
    System::ComponentModel::IContainer^ components;
};

public ref class ActiveThreadInfo
{
public:
    hctFilterToolStubImpl* filter;
    System::Windows::Forms::Form^ form;
    System::Threading::Thread^ thread;
};

public ref class ActiveThreadContainer
{
    public: static System::Collections::ArrayList^ s_activeThreads;
};

extern CRITICAL_SECTION __g_threadListCriticalSection;

void _AddThreadToActiveList(hctFilterToolStubImpl* filter, Form^ form)
{
    EnterCriticalSection(&__g_threadListCriticalSection);
    if (ActiveThreadContainer::s_activeThreads == nullptr)
    {
        ActiveThreadContainer::s_activeThreads = gcnew System::Collections::ArrayList;
    }

    ActiveThreadInfo^ ti = gcnew ActiveThreadInfo();
    ti->filter = filter;
    ti->form = form;
    ti->thread = System::Threading::Thread::CurrentThread;
    ActiveThreadContainer::s_activeThreads->Add( ti );
    LeaveCriticalSection(&__g_threadListCriticalSection);
}

delegate void progressVoidDelegate( );

void _CloseActiveThread(hctFilterToolStubImpl* owner)
{
    EnterCriticalSection(&__g_threadListCriticalSection);
    if (ActiveThreadContainer::s_activeThreads != nullptr)
    {
        System::Threading::Thread^ curThread = System::Threading::Thread::CurrentThread;
        for (int t=0; t < ActiveThreadContainer::s_activeThreads->Count; ++t)
        {
            ActiveThreadInfo^ ti = (ActiveThreadInfo^)ActiveThreadContainer::s_activeThreads[t];
            if (ti->filter == owner )
            {
                try
                {
                    ti->form->Invoke( gcnew progressVoidDelegate(ti->form, &Form::Close ) );
                }
                catch (...)
                {
                    // Safe to assume it is already closing then (window gone)
                    // Only exception to this is if window opening but we aleays wait for that so should not happen
                }
                break;
            }
        }
    }
    LeaveCriticalSection(&__g_threadListCriticalSection);
}

bool IsOnActiveList(System::Threading::Thread^ tr)
{
    EnterCriticalSection(&__g_threadListCriticalSection);
    if (ActiveThreadContainer::s_activeThreads != nullptr)
    {
        for (int t=0; t < ActiveThreadContainer::s_activeThreads->Count; ++t)
        {
            ActiveThreadInfo^ ti = (ActiveThreadInfo^)ActiveThreadContainer::s_activeThreads[t];
            if (ti->thread == tr)
            {
                LeaveCriticalSection(&__g_threadListCriticalSection);
                return true;
            }
        }
    }
    LeaveCriticalSection(&__g_threadListCriticalSection);
    return false;
}

void _RemoveThreadFromActiveList()
{
    EnterCriticalSection(&__g_threadListCriticalSection);
    if (ActiveThreadContainer::s_activeThreads != nullptr)
    {
        System::Threading::Thread^ curThread = System::Threading::Thread::CurrentThread;
        for (int t=0; t < ActiveThreadContainer::s_activeThreads->Count; ++t)
        {
            ActiveThreadInfo^ ti = (ActiveThreadInfo^)ActiveThreadContainer::s_activeThreads[t];
            if (ti->thread == curThread )
            {
                ActiveThreadContainer::s_activeThreads->RemoveAt(t);
                break;
            }
        }

        if (ActiveThreadContainer::s_activeThreads->Count == 0)
        {
            ActiveThreadContainer::s_activeThreads = nullptr;
        }
    }
    LeaveCriticalSection(&__g_threadListCriticalSection);
}


void showTool(hctFilterToolStubImpl* filterImpl)
{
    Application::EnableVisualStyles();
    Application::SetCompatibleTextRenderingDefault(false);
    String^ renderer = filterImpl->m_renderer.getLength() > 0 ? gcnew String(filterImpl->m_renderer.cString()) : nullptr;
    FilterMainForm^ form = gcnew FilterMainForm(renderer);
    IntPtr rootPtr( (void*) filterImpl->m_currentContainer );

    const bool copyScene = true; // as we don't share the same base sys with the Preview
    const bool allowInstances = true; // shouldn't be anything else in there anyway
    form->havokUI->SetContentsFromMemory( rootPtr, IntPtr( HK_NULL ), copyScene, allowInstances);

    _AddThreadToActiveList( filterImpl, form );

    Application::Run(form);

    _RemoveThreadFromActiveList();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
