// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hctFilterToolStubImpl : public hctModelessFilter
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

        hctFilterToolStubImpl(const hctFilterManagerInterface* owner);
        /*virtual*/ ~hctFilterToolStubImpl();

        /*
        ** From hkModelessfilter
        */

        /// Access to the descriptor.
        /*virtual*/ hctModelessFilterDescriptor& getDescriptor() const;

        // Processing
        /*virtual*/ void modalProcess ( class hkRootLevelContainer& data );
        /*virtual*/ void process( hkRootLevelContainer& contents );

        /// The filter manager may request us to close as soon as possible
        /*virtual*/ void tryToClose();

        /// Returns true if the filter is closing down
        /*virtual*/ bool isClosingDown () const;

        /*
        ** From hctFilterInterface
        */

        virtual void setOptions(const hkReflect::Var& optVar) HK_OVERRIDE;
        /*virtual*/ HWND showOptions(HWND owner);

        virtual void getOptions(hkReflect::Any& buffer) const HK_OVERRIDE;

        /*virtual*/ void hideOptions();

        // public for the dialog
    public:


        /// True if the user is trying to close us
        bool m_closeRequested;

        // True when closing down the filter (as it may take a while)
        bool m_closingDown;

        void updateOptions();

        hkStringOld m_renderer;

        // A buffer for storing the options in XML form.
        mutable hkArray<char> m_optionsBuf;

        HWND m_ownerWindow;
        class hkRootLevelContainer* m_currentContainer;

        HWND m_optionsDialog;
};

class hctFilterToolStubImplDesc : public hctModelessFilterDescriptor
{
    public:

        virtual unsigned int getID() const { return 0x700030cb; }
        virtual FilterCategory getCategory() const { return HK_CATEGORY_GRAPHICS; }
        virtual FilterBehaviour getFilterBehaviour() const { return HK_DATA_PASSTHRU; }
        virtual const char* getShortName() const { return "Preview Tool"; }
        virtual const char* getLongName() const { return "The Preview Tool, run through the filter pipeline. Supports: Physics, Animation, Cloth, Destruction, AI"; }
        virtual unsigned int getFilterVersion() const { return HCT_FILTER_VERSION(1,1,3); }
        virtual hctFilterInterface* createFilter(const hctFilterManagerInterface* owner) const { return new hctFilterToolStubImpl(owner); }
        virtual HavokComponentMask getRequiredHavokComponents () const { return HK_COMPONENT_COMMON; }
};

extern hctFilterToolStubImplDesc* g_stubToolFilterDesc;

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
