// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Filters/FilterTool/hctFilterToolStub.h>


#pragma unmanaged

// Windows.h, hkbase etc:
#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>
#include <ContentTools/Common/Tool/ToolInterfaces/ToolInterfaceMacros.h>


#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>

#include <tchar.h>

#include <Filters/FilterTool/Inline/hctFilterToolStubImpl.h>
#include <Filters/FilterTool/Inline/hctFilterToolStubImplOptions.h>

#include <Filters/FilterTool/resource.h>

hctFilterToolStubImplDesc* g_stubToolFilterDesc = NULL;
extern HINSTANCE hInstance;

#pragma managed

void showTool(hctFilterToolStubImpl* impl);
bool IsOnActiveList(System::Threading::Thread^ t);

#pragma unmanaged

hctFilterToolStubImpl::hctFilterToolStubImpl(const hctFilterManagerInterface* owner)
:   hctModelessFilter(owner), m_closeRequested(false), m_closingDown(false), m_renderer(""), m_ownerWindow(HK_NULL), m_currentContainer(HK_NULL)
{

}

hctFilterToolStubImpl::~hctFilterToolStubImpl()
{

}

BOOL CALLBACK hkManagedPreviewFilterDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

HWND hctFilterToolStubImpl::showOptions ( HWND owner )
{
    if (m_optionsDialog)
        hideOptions();

    m_optionsDialog = CreateDialogParamW(hInstance, MAKEINTRESOURCEW(IDD_MANAGEDPREVIEWTOOLOPTIONS),
        owner, (DLGPROC)hkManagedPreviewFilterDialogProc, (LPARAM)this );

    return m_optionsDialog;
}

void hctFilterToolStubImpl::hideOptions ()
{
    if (m_optionsDialog)
    {
        DestroyWindow(m_optionsDialog);
    }
    m_optionsDialog = NULL;
}


/*virtual*/ hctModelessFilterDescriptor& hctFilterToolStubImpl::getDescriptor() const
{
    return *g_stubToolFilterDesc;
}

void _CloseActiveThread(hctFilterToolStubImpl* owner);

/*virtual*/ void hctFilterToolStubImpl::tryToClose()
{
    m_closeRequested = true;
    _CloseActiveThread(this);
}

/*virtual*/ bool hctFilterToolStubImpl::isClosingDown () const
{
    return m_closingDown;
}


/*virtual*/ void hctFilterToolStubImpl::modalProcess ( hkRootLevelContainer& data )
{
    // Not allowed use the same instance of a modeless filter twice. Should have created a new one.
    if (m_currentContainer) return;

    m_currentContainer = &data;

    //m_infoString = hctFilterUtils::getEnvironmentVariable(data, "infoString");
    m_ownerWindow = m_filterManager->getOwnerWindowHandle();

    // Do the preview. Will return when window closes.
    showTool(this );

    m_closingDown = true;
}

void hctFilterToolStubImpl::setOptions(const hkReflect::Var& optVar)
{
    if (hctFilterToolStubImplOptions* options = hctFilterUtils::getNativeOptions<hctFilterToolStubImplOptions>(optVar))
    {
        m_renderer = options->m_renderer;
        delete options;
    }
}

void hctFilterToolStubImpl::getOptions(hkReflect::Any& buffer) const
{
    hctFilterToolStubImplOptions options;
    options.m_renderer = (char*)m_renderer.cString();
    buffer.setFromObj( options );
}


struct _ThreadProcessingData
{
    hctModelessFilter* m_filter;
    hkRootLevelContainer* m_contents;

};

#pragma managed




static void _normalThread( hctModelessFilter* filter, hkRootLevelContainer* contents)
{
    hkMemoryRouter mem;
    hkMemorySystem::getInstance().threadInit(mem, "hctFilterToolStub");
    // Due to the fact that all the DLLs that created the data for this preview
    // have their own TLS slot for the per thread memory etc, we have to propagate that
    // back though them all..
    {
        // call hkBaseSystem::initThread( &threadMemory ); on all DLLs known to manager (including this one, so we don't need to call it explicitly)
        filter->getFilterManager()->setThreadData(&mem);
    }

    // Do the processing
    filter->modalProcess(*contents);

    const hctFilterManagerInterface* manager = filter->getFilterManager();

    filter->getDescriptor().removeFilterFromActiveList(filter); // will delete 'filter'

    // Play nice..
    manager->setThreadData(HK_NULL);

    hkMemorySystem::getInstance().threadQuit(mem);
}



//
// To get around thread compartment issue (has to be STA)
//

private ref class PreviewThread
{
public:

    PreviewThread( hctFilterToolStubImpl* filter, hkRootLevelContainer* root )
    {
        m_filter = filter;
        m_root = root;
    }

    void Exec()
    {
        ::_normalThread(m_filter, m_root);
    }

    hctFilterToolStubImpl* m_filter;
    hkRootLevelContainer* m_root;
};


void processManaged( hctFilterToolStubImpl* filter, hkRootLevelContainer& contents )
{
    // Create preview thread:
    // easier to make it a managed thread, that way the COM opartment model etc will be correct

    PreviewThread^ previewThread = gcnew PreviewThread( filter, &contents );
    System::Threading::ThreadStart^ theThreadStarter = gcnew System::Threading::ThreadStart(previewThread, &PreviewThread::Exec);
    System::Threading::Thread^ pThread = gcnew System::Threading::Thread(theThreadStarter);
    pThread->SetApartmentState( System::Threading::ApartmentState::STA );// The magic sauce to make sure that the DragNDrop etc work (requires COM calls etc from the Windows Forms).
    pThread->Start();

    // don't continue until contents loaded. This saves us having to do a scene copy in addition to the one Preview does internally
    while (!IsOnActiveList(pThread))
    {
        Sleep(0);
    }
}


void hctFilterToolStubImpl::process( hkRootLevelContainer& contents  )
{
    hctFilterManagerInterface::ProcessMode mode = getFilterManager()->getProcessMode();
    if ((mode == hctFilterManagerInterface::PROCESS_BATCH) || (mode == hctFilterManagerInterface::OPTIONS_BATCH))
    {
        return;
    }

    if (behaveAsModal())
    {
        modalProcess(contents);
        return;
    }


    // else

    // We add it before creating the thread since we need to make sure the filter is not deleted while the thread starts
    // Thread will remove itself when finished
    getDescriptor().addFilterToActiveList(this);

    processManaged(this, contents);

}

#pragma unmanaged

static PWCHAR g_rendererNames[] =
{
    TEXT("Default (Use Tool Settings)"),
    TEXT("DirectX9"),
    TEXT("DirectX11"),
    TEXT("OpenGL ES 1.0"),
    TEXT("OpenGL ES 2.0")
};

static const char* g_rendererStrings[] =
{
    "",
    "d3d9",
    "d3d11",
    "ogles",
    "ogles2"
};

BOOL CALLBACK hkManagedPreviewFilterDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctFilterToolStubImpl* previewToolFilter = reinterpret_cast<hctFilterToolStubImpl*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch(message)
    {
    case WM_INITDIALOG:
        {
            previewToolFilter = (hctFilterToolStubImpl*)lParam;
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            // Init options:
            HWND hwndCombo = GetDlgItem(hWnd, IDC_RENDERER);

            // Default renderer in case we have an invalid one
            int numRenderers = sizeof(g_rendererNames) / sizeof(LPCSTR);
            int curRenderer = 0;
            for (int p=0; p < numRenderers; ++p)
            {
                SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM) g_rendererNames[p] );
                if (hkString::strCmp( g_rendererStrings[p], previewToolFilter->m_renderer.cString() ) == 0)
                {
                    curRenderer = p;
                }
            }

            SendMessage(hwndCombo, CB_SETCURSEL, (WPARAM)(curRenderer), 0);
        }
        return TRUE; // did handle it

    case WM_COMMAND:
        {
            switch ( LOWORD(wParam) )
            {
                case IDC_RENDERER: // selection change etc
                {
                    HWND hwndCombo = GetDlgItem(hWnd, IDC_RENDERER);
                    int ir = (int)SendMessage(hwndCombo, CB_GETCURSEL, 0, 0);
                    if ((ir != CB_ERR) && previewToolFilter)
                    {
                        previewToolFilter->m_renderer = g_rendererStrings[ir];
                    }
                    break;
                }
            }
            break;
        }
    }
    return FALSE; //didn't handle it / didn't do much with it
}
#pragma managed

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
