// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>
#include <ContentTools/Common/Filters/FilterTexture/hctFilterTextureUtils.h>


#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>


static void recursivelyFindSceneMaterials(hkxMaterial* current, hkArray<hkxMaterial*>& sceneMaterials)
{
    if (current != HK_NULL)
    {
        sceneMaterials.pushBack(current);
    }

    for (int i=0; i< current->m_subMaterials.getSize(); i++)
    {
        recursivelyFindSceneMaterials(current->m_subMaterials[i], sceneMaterials);
    }
}

void HK_CALL hctFilterTextureUtils::findSceneMaterials(hkxScene& scene, hkArray<hkxMaterial*>& sceneMaterials)
{
    for (int cim = 0; cim < scene.m_materials.getSize(); ++cim)
    {
        recursivelyFindSceneMaterials( scene.m_materials[cim], sceneMaterials) ;
    }
}

void HK_CALL hctFilterTextureUtils::findFileTextures( hkxScene& scene, hkArray<hkxTextureFile*>& fileBasedTextures, hkArray<hkxMaterial::TextureType>* typeInfo )
{
    if (scene.m_materials.getSize() > 0)
    {
        hkArray<hkxMaterial*> sceneMaterials;
        findSceneMaterials(scene, sceneMaterials);

        for (int cim = 0; cim < sceneMaterials.getSize(); ++cim)
        {
            hkxMaterial* material = sceneMaterials[cim];
            for (int net = 0; net < material->m_stages.getSize(); ++net)
            {
                if ( hkxTextureFile* textureFile = hkDynCast<hkxTextureFile>(material->m_stages[net].m_texture) )
                {
                    if (fileBasedTextures.indexOf(textureFile) < 0)
                    {
                        fileBasedTextures.pushBack( textureFile );
                        if (typeInfo )
                        {
                            typeInfo->pushBack( material->m_stages[net].m_usageHint );
                        }
                    }
                }
            }
        }
    }
}


void HK_CALL hctFilterTextureUtils::findInplaceTextures( hkxScene& scene, hkArray<hkxTextureInplace*>& inplaceTextures, hkArray<hkxMaterial::TextureType>* typeInfo )
{
    if (scene.m_materials.getSize() > 0)
    {
        hkArray<hkxMaterial*> sceneMaterials;
        findSceneMaterials(scene, sceneMaterials);

        for (int cim = 0; cim < sceneMaterials.getSize(); ++cim)
        {
            hkxMaterial* material = sceneMaterials[cim];
            for (int net = 0; net < material->m_stages.getSize(); ++net)
            {
                if( hkxTextureInplace* textureInplace = hkDynCast<hkxTextureInplace>(material->m_stages[net].m_texture) )
                {
                    if (inplaceTextures.indexOf(textureInplace) < 0)
                    {
                        inplaceTextures.pushBack( textureInplace );

                        if (typeInfo )
                        {
                            typeInfo->pushBack( material->m_stages[net].m_usageHint );
                        }
                    }
                }
            }
        }
    }
}

void HK_CALL hctFilterTextureUtils::getFullTexturePath( const char* filename, hkRootLevelContainer& data, hkStringOld& fullPath )
{
    const char* assetFolder = hctFilterUtils::getEnvironmentVariable(data, "assetFolder");
    hkStringOld fileName(filename);
    if (assetFolder && (fileName.beginsWith(".") || (fileName.lastIndexOf(':')<0) ) && (!fileName.beginsWith("\\")))
    {
        fullPath = hkStringOld(assetFolder) + "/" + fileName;
    }
    else
    {
        fullPath = fileName;
    }
}

const char* HK_CALL hctFilterTextureUtils::hintToText(hkxMaterial::TextureType t)
{
    switch (t)
    {
    case hkxMaterial::TEX_DIFFUSE:
        return "Diffuse Map";
    case hkxMaterial::TEX_REFLECTION:
        return "Reflection Map";
    case hkxMaterial::TEX_BUMP:
        return "Bump Map";
    case hkxMaterial::TEX_NORMAL:
        return "Normal Map";
    case hkxMaterial::TEX_DISPLACEMENT:
        return "Displacement Map";
    case hkxMaterial::TEX_SPECULAR:
        return "Specular Map";
    case hkxMaterial::TEX_SPECULARANDGLOSS:
        return "Specular&Gloss Map";
    case hkxMaterial::TEX_OPACITY:
        return "Opacity Map";
    case hkxMaterial::TEX_EMISSIVE:
        return "Emissive Map";
    case hkxMaterial::TEX_REFRACTION:
        return "Refraction Map";
    case hkxMaterial::TEX_GLOSS:
        return "Gloss Map";
    default:
        return "Unknown map type";
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
