// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTextureDll.h>

// Filters we want to expose in this dll:
#include <ContentTools/Common/Filters/FilterTexture/RemoveTexturePaths/hctRemoveTexturePathsFilter.h>

#include <ContentTools/Common/Filters/FilterTexture/CompressTexture/hctCompressTextureFilter.h>
#include <ContentTools/Common/Filters/FilterTexture/EmbedTexture/hctEmbedTextureFilter.h>
#include <ContentTools/Common/Filters/FilterTexture/GatherAndConvertTexture/hctGatherAndConvertTextureFilter.h>

// Scene Data classes only
//define HK_CLASSES_FILE <Common/SceneData/Classes/hkSceneDataClasses.h> //todo.nt4
#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#include <Common/Base/Config/hkProductFeatures.cxx>


__declspec( dllexport ) hctFilterDll* getFilterDll (HMODULE dllModule)
{
    static hctFilterTextureDll gFilterTextureDll (dllModule);

    return &gFilterTextureDll;
}


hctFilterTextureDll::hctFilterTextureDll (HMODULE dllModule) : hctFilterDll (dllModule)
{

}

/*virtual*/ int hctFilterTextureDll::getNumberOfFilters() const
{
    return 4;
}

/*virtual*/ hctFilterDescriptor* hctFilterTextureDll::getFilterDescriptor (int index) const
{
    static hctFilterDescriptor* m_filterDescs[] =
    {
        &g_removeTexturePathsDesc,
        &g_compressTextureDesc,
        &g_embedTextureDesc,
        &g_gatherAndConvertTextureDesc
    };

    return m_filterDescs[index];
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
