// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>

#include <stdio.h>

// DLL main
HINSTANCE hInstance;
static BOOL CommonControlsInitialized = FALSE;


// We use delay loading of the DLL so that we can handle when the FreeImage or NVTT DLLs are not present
// and return gracefully to not using those filters
#define DELAYIMP_INSECURE_WRITABLE_HOOKS 
#include <delayimp.h>
#pragma comment(lib, "delayimp")

#if defined(_MSC_FULL_VER) && (_MSC_FULL_VER >= 190024210) 
PfnDliHook   __pfnDliFailureHook2 = 0;
#else
ExternC PfnDliHook __pfnDliFailureHook2;
#endif
static PfnDliHook   __prev_pfnDliFailureHook2;

#ifdef HK_DEBUG
#   define NVTT_DLL_NAME "nvtt.dll"
#   define FREEIMAGE_DLL_NAME "FreeImage.dll"

#   pragma comment(lib, "nvtt.lib")
#   pragma comment(lib, "FreeImage.lib")
#else
#   define NVTT_DLL_NAME "nvtt.dll"
#   define FREEIMAGE_DLL_NAME "FreeImage.dll"

#   pragma comment(lib, "nvtt.lib")
#   pragma comment(lib, "FreeImage.lib")
#endif

static void _AddExtraSearchPaths()
{
    const char* envVar = ::getenv( ENVVAR_FILTER_ROOT );
    char buf[4096];
    if (envVar && envVar[0])
    {
        ::sprintf(buf, "%s\\bin", envVar );
        SetDllDirectory(buf);
        return;
    }

    // try the Havok Tools bin folder too if installed (it usually has a few handy ones)
    HKEY filterReg;
    DWORD dispos;

#ifdef HK_PLATFORM_WIN64
    const TCHAR* _HAVOK_FILTERS_REG_KEY = TEXT("Software\\Havok\\hkFilters_x64");
#else
    const TCHAR* _HAVOK_FILTERS_REG_KEY = TEXT("Software\\Havok\\hkFilters");
#endif

    RegCreateKeyEx( HKEY_CURRENT_USER, _HAVOK_FILTERS_REG_KEY, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &filterReg, &dispos);
    LPSTR filtersPath[1024];
    DWORD filtersPathSize = 1024;

    if( RegQueryValueEx( filterReg, TEXT("FilterPath"), NULL, NULL, (LPBYTE)filtersPath, &filtersPathSize ) == ERROR_SUCCESS )
    {
        if (filtersPath[0])
        {
            ::sprintf(buf, "%s\\bin", (const char*)filtersPath );
            SetDllDirectory(buf);
        }
    }
    RegCloseKey(filterReg);

}

FARPROC WINAPI _delayLoadFailureFunc(unsigned dliNotify, PDelayLoadInfo  pdli)
{
    // always defer to user one (if present)
    char buf[4096];
    if (__prev_pfnDliFailureHook2)
    {
        FARPROC rval = __prev_pfnDliFailureHook2(dliNotify, pdli);
        if (rval)
        {
            return rval;
        }
    }

    if (dliNotify == dliFailLoadLib)
    {
        // try a few more places other than DLL search path.
        HMODULE module = HK_NULL;

        // If it's not there, look for the HAVOK_TOOLS_ROOT environment variable.
        ::sprintf(buf, "%s\\bin\\%s", ::getenv( ENVVAR_FILTER_ROOT ), pdli->szDll );
        module = LoadLibrary( buf ); // try to load the debug version

        if (!module)
        {
            // try the Havok Tools bin folder too if installed (it usually has a few handy ones)
            HKEY filterReg;
            DWORD dispos;

    #ifdef HK_PLATFORM_WIN64
            const TCHAR* _HAVOK_FILTERS_REG_KEY = TEXT("Software\\Havok\\hkFilters_x64");
    #else
            const TCHAR* _HAVOK_FILTERS_REG_KEY = TEXT("Software\\Havok\\hkFilters");
    #endif

            RegCreateKeyEx( HKEY_CURRENT_USER, _HAVOK_FILTERS_REG_KEY, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &filterReg, &dispos);
            LPSTR filtersPath[1024];
            DWORD filtersPathSize = 1024;
            if( RegQueryValueEx( filterReg, TEXT("FilterPath"), NULL, NULL, (LPBYTE)filtersPath, &filtersPathSize ) == ERROR_SUCCESS )
            {
                ::sprintf(buf, "%s\\bin\\%s", (const char*)filtersPath, pdli->szDll );
                module = LoadLibrary( buf ); // try to load the debug version
            }
            RegCloseKey(filterReg);
        }

        return (FARPROC)module;
    }

    return 0;
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved)
{
    switch ( fdwReason )
    {
        case DLL_PROCESS_ATTACH:
        {
            hInstance = hinstDLL;               // Hang on to this DLL's instance handle.

            if (!CommonControlsInitialized) {

                CommonControlsInitialized = TRUE;
                InitCommonControls();           // Initialize Win32 controls

                __prev_pfnDliFailureHook2 = __pfnDliFailureHook2;
                __pfnDliFailureHook2 = _delayLoadFailureFunc;

                // NVTT does not delay load it's dlls, so we need to use the Windows search paths
                _AddExtraSearchPaths(); // will only work in XP SP2 or Vista..

                // See if we can load the delayed DLLs now (can add messges etc on FALSE here etc)
                __HrLoadAllImportsForDll(NVTT_DLL_NAME);
                __HrLoadAllImportsForDll(FREEIMAGE_DLL_NAME);
            }
            break;
        }

        case DLL_PROCESS_DETACH:
        {
            if (CommonControlsInitialized)
            {
                CommonControlsInitialized = FALSE;
            }
        }

        case DLL_THREAD_ATTACH:
        case DLL_THREAD_DETACH:
            break;
    }
    return TRUE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
