// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>

#include <ContentTools/Common/Filters/FilterTexture/RemoveTexturePaths/hctRemoveTexturePathsFilter.h>

#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>

#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureFile.h>

#include <tchar.h>

#include <ContentTools/Common/Filters/FilterTexture/RemoveTexturePaths/hctRemoveTexturePathsOptions.h>

hctRemoveTexturePathsFilterDesc g_removeTexturePathsDesc;

hctRemoveTexturePathsFilter::hctRemoveTexturePathsFilter(const hctFilterManagerInterface* owner)
:   hctFilterInterface (owner),
    m_optionsDialog(NULL)
{
}

hctRemoveTexturePathsFilter::~hctRemoveTexturePathsFilter()
{

}

void hctRemoveTexturePathsFilter::process( hkRootLevelContainer& data  )
{
    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }
    hkxScene& scene = *scenePtr;

    // Pre process our paths into a set of lower case strs..
    // XX TODO: don't have to do this in process, move to setoptions etc.
    hkArray< hkStringOld > lowerCasePaths;
    if (scene.m_materials.getSize() >= 0)
    {
        int curChar = 0;
        const char* paths = m_paths.cString();
        while ( paths[curChar] )
        {
            int endChar = curChar;
            while (paths[endChar] && paths[endChar] != ';')
                endChar++;

            hkStringBuf strb(&paths[curChar], endChar - curChar);
            strb.lowerCase();
            strb.pathNormalize();

            lowerCasePaths.expandOne() = hkStringOld(strb.cString());

            curChar = paths[endChar]? endChar + 1 : endChar;
        }
    }

    // we don't need to regsiter any classes as we are not adding any extra types
    // that are not 'known' already.

    // Find all our textures
    for (int cim = 0; cim < scene.m_externalTextures.getSize(); ++cim)
    {
        hkxTextureFile* curTexture = scene.m_externalTextures[cim];

        // for each path, if that path is contained in the filename, remove the longest perhaps?
        // or can we assume the paths don't overlap.
        // For now, just take out only:
        int bestPathIndex = -1;
        int longestPath = 0;

        hkStringBuf strb(curTexture->m_filename);
        strb.lowerCase();
        strb.pathNormalize();

        hkStringOld pathAsStr(strb.cString());

        for (int cp=0; cp < lowerCasePaths.getSize(); ++cp)
        {
            hkStringOld& lowerCasePath = lowerCasePaths[cp];
            int pl = lowerCasePath.getLength();

            const char* ss = hkString::strStr( pathAsStr.cString(), lowerCasePath.cString() );

            if (ss && ( ss == pathAsStr.cString() ))// have a strstr and it is at the start
            {
                if (longestPath < pl)
                {
                    longestPath = pl;
                    bestPathIndex = cp;
                }
            }
        }

        if (longestPath > 0)
        {
            hkStringBuf newPath(curTexture->m_filename);
            newPath.chompStart( longestPath );
            curTexture->m_filename = newPath.cString();
        }
    }// all external textures
}

void hctRemoveTexturePathsFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctRemoveTexturePathsOptions* options = hctFilterUtils::getNativeOptions<hctRemoveTexturePathsOptions>(optVar))
    {
        m_paths = options->m_texturePaths;
        delete options;
    }
}

void hctRemoveTexturePathsFilter::getOptions(hkReflect::Any& buffer) const
{
    hctRemoveTexturePathsOptions options;
    options.m_texturePaths = (char*)m_paths.cString();
    buffer.setFromObj( options );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
