// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


/// Options detailing texture size reduction.
class hctGatherAndConvertTextureFilterOptions
{
    public:

        HK_DECLARE_CLASS(hctGatherAndConvertTextureFilterOptions, New, Reflect);

            /// Default constructor
        hctGatherAndConvertTextureFilterOptions() { }

        //
        // Members
        //
    public:

        // A reasonable subset of the FreeImage 3.10 supported formats:
        enum OutputFormat
        {
            OF_BMP      = 0,  // Supported by PC based HKG platforms
            OF_JPEG     = 2,
            OF_PNG      = 13, // Supported by all HKG platforms
            OF_TARGA    = 17, // Supported by all HKG platforms if one of the common uncomressed / simple styles
            OF_TIFF     = 18,
            OF_HDR      = 26
        };

        enum DitherAlgo
        {
            DTH_NONE        = -1,
            DTH_FS          = 0,
            DTH_BAYER4x4    = 1,
            DTH_BAYER8x8    = 2,
            DTH_CLUSTER6x6  = 3,
            DTH_CLUSTER8x8  = 4,
            DTH_CLUSTER16x16= 5,
            DTH_BAYER16x16  = 6
        };

        enum ToneMapAlgo
        {
            TM_NONE       = -1,
            TM_DRAGO03   = 0,
            TM_REINHARD05 = 1,
            TM_FATTAL02
        };

        enum ResizeFilter
        {
            RF_NONE       = -1,
            RF_BOX        = 0,
            RF_BICUBIC    = 1,
            RF_BILINEAR   = 2,
            RF_BSPLINE    = 3,
            RF_CATMULLROM = 4,
            RF_LANCZOS3
        };

        struct ConvertOptions
        {
            HK_DECLARE_CLASS(ConvertOptions, New, Reflect);

            ConvertOptions() {}

            hkStringPtr m_textureName; // the texture these options are for

            hkEnum<OutputFormat, hkInt8> m_format;

            hkEnum<DitherAlgo, hkInt8> m_dither;

            hkEnum<ResizeFilter, hkInt8> m_resizeFilter;
            hkUint16 m_xTexels;
            hkUint16 m_yTexels;

            hkBool m_useOriginalFilename; // always use the original file as the source to load

        };

        // If sizeof m_options is 1, and texture name is null, then will be applied to all textures
        hkArray< struct ConvertOptions > m_perTextureOptions;

        hkStringPtr m_outputTexturePath; // where to place file based textures (path will be stripped and this added, along with new file ext if one)
        hkBool m_allowOverwrite;
};

HK_REFLECT_ENUM(/**/, hctGatherAndConvertTextureFilterOptions::OutputFormat);
HK_REFLECT_ENUM(/**/, hctGatherAndConvertTextureFilterOptions::DitherAlgo);
HK_REFLECT_ENUM(/**/, hctGatherAndConvertTextureFilterOptions::ResizeFilter);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
