// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>
#include <ContentTools/Common/Filters/FilterTexture/EmbedTexture/hctEmbedTextureFilter.h>
#include <ContentTools/Common/Filters/FilterTexture/hctFilterTextureUtils.h>

#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/Base/Serialize/Resource/hkResource.h>
#include <windowsx.h>

extern HINSTANCE hInstance;

INT_PTR CALLBACK hkFilterEmbedTexturesDialogProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    hctEmbedTextureFilter* filter = reinterpret_cast<hctEmbedTextureFilter*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch( message )
    {
        case WM_INITDIALOG:
        {
            filter = (hctEmbedTextureFilter*)lParam;
            SetWindowLongPtr( hWnd, GWLP_USERDATA, (LONG_PTR)lParam ); // so that it can be retrieved later

            // make our image of the current root inc processing up to our filter
            filter->getFilterManager()->getInputContentsToCurrentFilter( &filter->m_optionSceneData, filter->m_optionSceneDataTracker);

            hkxScene* scenePtr = filter->m_optionSceneData->findObject<hkxScene>();
            HWND texListWnd = GetDlgItem( hWnd, IDC_EMBED_TEXTURENAME_LIST);

            filter->m_listedTextures.setSize(0);
            if (scenePtr != HK_NULL)
            {
                hctFilterTextureUtils::findFileTextures( *scenePtr, filter->m_listedTextures );

                int numItems = 0;
                for (int t=0; t < filter->m_listedTextures.getSize(); ++t)
                {
                    const char* tname = filter->m_listedTextures[t]->m_name? filter->m_listedTextures[t]->m_name : filter->m_listedTextures[t]->m_filename;
                    if (tname)
                    {
                        ListBox_AddString( texListWnd, tname);

                        for (int tt=0; tt < filter->m_options.m_texturesToEmbed.getSize(); ++tt)
                        {
                            if (hkString::strCmp( tname, filter->m_options.m_texturesToEmbed[tt]) ==0 )
                            {
                                ListBox_SetSel( texListWnd, TRUE, numItems );
                                break;
                            }
                        }
                        numItems++;
                    }
                }
            }

            bool haveSelectedTextures = filter->m_options.m_texturesToEmbed.getSize() > 0;
            CheckDlgButton( hWnd, IDC_EMBED_SELECTALL, !haveSelectedTextures );
            EnableWindow( texListWnd, haveSelectedTextures );

            return TRUE; // did handle it
        }

        case WM_COMMAND: // UI Changes
        {
            switch ( LOWORD( wParam ) )
            {
                case IDC_EMBED_SELECTALL:
                {
                    HWND texListWnd = GetDlgItem( hWnd, IDC_EMBED_TEXTURENAME_LIST);
                    if( IsDlgButtonChecked( hWnd, IDC_EMBED_SELECTALL ) == TRUE )
                    {
                        EnableWindow( texListWnd, FALSE);
                    }
                    else
                    {
                        EnableWindow( texListWnd, TRUE);
                    }
                    break;
                }

            }
        }

        default:
        {
            return FALSE;   //didn't handle it / didn't do much with it
        }

    }
}

HWND hctEmbedTextureFilter::showOptions( HWND owner)
{
    if( m_optionsDialog )
    {
        hideOptions();
    }

    // dealloc previous
    if (m_optionSceneDataTracker)
    {
        m_optionSceneDataTracker->removeReference();
        m_optionSceneDataTracker = HK_NULL;
    }

    m_optionsDialog = CreateDialogParamW( hInstance, MAKEINTRESOURCEW( IDD_EMBED_DIALOG ),
        owner, hkFilterEmbedTexturesDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctEmbedTextureFilter::updateOptions()
{
    if( m_optionsDialog )
    {
        m_options.m_texturesToEmbed.setSize(0);
        m_nameStrings.setSize(0);
        if( IsDlgButtonChecked(m_optionsDialog, IDC_EMBED_SELECTALL) == FALSE )
        {
            // select the textures
            HWND texListWnd = GetDlgItem( m_optionsDialog, IDC_EMBED_TEXTURENAME_LIST);
            int numSelected = ListBox_GetSelCount( texListWnd );
            if (numSelected > 0)
            {
                int selectedIndices[256];
                ListBox_GetSelItems(texListWnd, 256, selectedIndices);
                for (int s=0; s < numSelected; ++s)
                {
                    hkxTextureFile* tex = m_listedTextures[ selectedIndices[s] ];
                    if (tex->m_name)
                    {
                        m_nameStrings.expandOne() = tex->m_name;
                    }
                    else
                    {
                        m_nameStrings.expandOne() = tex->m_filename;
                    }
                }
            }

            m_options.m_texturesToEmbed.setSize(m_nameStrings.getSize());
            for (int st=0; st < m_nameStrings.getSize(); ++st)
            {
                m_options.m_texturesToEmbed[st] = const_cast<char* >(m_nameStrings[st].cString());
            }
        }
    }
}

void hctEmbedTextureFilter::hideOptions()
{
    updateOptions();
    if( m_optionsDialog )
    {
        DestroyWindow( m_optionsDialog );
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
