// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>
#include <ContentTools/Common/Filters/FilterTexture/EmbedTexture/hctEmbedTextureFilter.h>
#include <ContentTools/Common/Filters/FilterTexture/hctFilterTextureUtils.h>

#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>
#include <Common/Base/System/Io/Util/hkLoadUtil.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.texture.embed"
#include <Common/Base/System/Log/hkLog.hxx>


hctEmbedTextureFilterDesc g_embedTextureDesc;

hctEmbedTextureFilter::hctEmbedTextureFilter(const hctFilterManagerInterface* owner)
: hctFilterInterface (owner), m_optionSceneData(HK_NULL), m_optionSceneDataTracker(HK_NULL), m_optionsDialog(HK_NULL)
{

}

hctEmbedTextureFilter::~hctEmbedTextureFilter()
{
    if (m_optionSceneDataTracker)
    {
        m_optionSceneDataTracker->removeReference();
    }
}



void hctEmbedTextureFilter::process( hkRootLevelContainer& data  )
{
    // Find the scene in the root level container
    hkxScene* scenePtr = data.findObject<hkxScene>();
    if (scenePtr == HK_NULL)
    {
        HK_WARN_ALWAYS(0xabbaa5f0, "No scene data found");
        return;
    }
    hkxScene& scene = *scenePtr;

    hkArray<hkxTextureFile*> doneTextures;
    hkArray<hkxTextureInplace*> replacementTextures;

    if (scene.m_materials.getSize()> 0)
    {
        hkArray<hkxMaterial*> sceneMaterials;
        hctFilterTextureUtils::findSceneMaterials(scene, sceneMaterials);

        for (int cim = 0; cim < sceneMaterials.getSize(); ++cim)
        {
            hkxMaterial* material = sceneMaterials[cim];

            for (int net = 0; net < material->m_stages.getSize(); ++net)
            {
                if ( !(material->m_stages[net].m_texture) )
                {
                    continue;
                }

                hkxTextureFile* textureFile = hkReflect::exactMatchDynCast<hkxTextureFile>(material->m_stages[net].m_texture);
                if (!textureFile)
                {
                    continue;
                }

                hkxTextureInplace* pTi = HK_NULL;

                bool skipTexture = m_options.m_texturesToEmbed.getSize() > 0;
                for (int toi=0; toi < m_options.m_texturesToEmbed.getSize(); ++toi)
                {
                    const char* tname = textureFile->m_name? textureFile->m_name : textureFile->m_filename;
                    if ( hkString::strCmp(m_options.m_texturesToEmbed[toi], tname) == 0 )
                    {
                        skipTexture = false;
                        break;
                    }
                }

                if (skipTexture)
                {
                    continue;
                }

                int doneIdx = doneTextures.indexOf(textureFile);
                if ( doneIdx >= 0)
                {
                    // done already
                    pTi = replacementTextures[doneIdx];
                }
                else
                {
                    // add so we don't try again
                    doneTextures.pushBack(textureFile);
                    replacementTextures.pushBack(HK_NULL);

                    hkStringOld filename = textureFile->m_filename;
                    hkStringOld filenameLowerCase =  filename.asLowerCase();
                    hkStringOld filenameExt = filename.substr( filename.lastIndexOf('.') + 1 );
                    const char* tname = textureFile->m_name? textureFile->m_name : "<none>";

                    if (filenameExt.getLength() < 3)
                    {
                        HK_WARN_ALWAYS(0xabba7ed3, "Unkown file type: " << filename.cString());
                        continue;
                    }


                    hkStringOld fullPath;
                    hctFilterTextureUtils::getFullTexturePath( filename.cString(), data, fullPath );

                    hkArray<char>::Temp pFile;
                    if( hkLoadUtil(fullPath.cString()).toArray(pFile) )
                    {
                        pTi = new hkxTextureInplace();
                        pTi->m_data.append(reinterpret_cast<hkUint8*>(pFile.begin()), pFile.getSize());
                        Log_Info( "Embedded texture: [{}] (Map name[{}])", filename.cString(), tname );
                    }
                    else
                    {
                        HK_WARN_ALWAYS(0xabba7ed3, "Couldn't load file: [" << filename.cString() << "],  (Map name[" << tname << "])");
                        continue;
                    }

                    // make our new texture
                    pTi->m_originalFilename = textureFile->m_originalFilename? textureFile->m_originalFilename : textureFile->m_filename;

                    filenameExt.makeUpperCase();
                    pTi->m_fileType[0] = filenameExt[0]; pTi->m_fileType[1] = filenameExt[1]; pTi->m_fileType[2] = filenameExt[2];
                    pTi->m_fileType[3] = '\0';
                    pTi->m_name = textureFile->m_name; // keep name
                    replacementTextures[replacementTextures.getSize()-1] = pTi;
                }

                // Replace it!
                if (pTi)
                {
                    material->m_stages[net].m_texture = pTi;
                }
            }

        } // all mats

    }
}

void hctEmbedTextureFilter::setOptions(const hkReflect::Var& optVar)
{
    if (hctEmbedTextureFilterOptions* options = hctFilterUtils::getNativeOptions<hctEmbedTextureFilterOptions>(optVar))
    {
        m_options = *options;
        delete options;
    }
}

void hctEmbedTextureFilter::getOptions(hkReflect::Any& buffer) const
{
    buffer.setFromObj( m_options );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
