// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTexture.h>
#include <ContentTools/Common/Filters/FilterTexture/CompressTexture/hctCompressTextureFilter.h>

#include <ContentTools/Common/Filters/FilterTexture/hctFilterTextureUtils.h>

#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>

#include <Common/Base/Serialize/Resource/hkResource.h>

#include <nvtt.h>

#include <windowsx.h>
#include <commctrl.h>
#include <shlobj.h>

extern HINSTANCE hInstance;


static void _getCurrentOptions( HWND hWnd, hctCompressTextureFilterOptions::ConvertOptions& opt )
{
    opt.m_format = (hctCompressTextureFilterOptions::OutputFormat) ComboBox_GetCurSel( GetDlgItem( hWnd, IDC_COMPRESS_FORMAT ) );
    opt.m_quality = (hctCompressTextureFilterOptions::OutputQuality) ComboBox_GetCurSel( GetDlgItem( hWnd, IDC_COMPRESS_QUALITY ) );
    opt.m_mipMapFilter = (hctCompressTextureFilterOptions::MipmapFilter) ComboBox_GetCurSel( GetDlgItem( hWnd, IDC_COMPRESS_MIPMAP ) );
    opt.m_flipX = IsDlgButtonChecked( hWnd, IDC_COMPRESS_FLIPX) == TRUE;
    opt.m_flipY = IsDlgButtonChecked( hWnd, IDC_COMPRESS_FLIPY) == TRUE;
    opt.m_useOriginalFilename = IsDlgButtonChecked( hWnd, IDC_COMPRESS_USEORIGNAME ) == TRUE;
}

static void _getCurrentSelectedOptions( HWND hWnd, hkArray<hctCompressTextureFilterOptions::ConvertOptions*>& options, hctCompressTextureFilter* filter )
{
    options.setSize(1);
    options[0] = &filter->m_options.m_perTextureOptions[0];

    if( IsDlgButtonChecked( hWnd, IDC_COMPRESS_APPLYTOALL ) == FALSE)
    {
        HWND texListWnd = GetDlgItem( hWnd, IDC_COMPRESS_TEXTURE_LIST);
        int numItems = ListView_GetItemCount( texListWnd );
        hkArray<int> optionsIndices;

        for (int i=0; i < numItems; ++i)
        {
            if (ListView_GetItemState( texListWnd, i, LVIS_SELECTED ) != 0)
            {
                bool fileBased = i < filter->m_listedFileTextures.getSize();
                const char* textureName = fileBased?
                    filter->m_listedFileTextures[i]->m_name :
                filter->m_listedInplaceTextures[i-filter->m_listedFileTextures.getSize()]->m_name;

                int haveOptions= false;
                for (int tt=0; textureName && (tt < filter->m_options.m_perTextureOptions.getSize()); ++tt)
                {
                    if (filter->m_options.m_perTextureOptions[tt].m_textureName && hkString::strCmp( textureName, filter->m_options.m_perTextureOptions[tt].m_textureName) ==0 )
                    {
                        // found
                        haveOptions = true;
                        optionsIndices.pushBack(tt);
                        break;
                    }
                }

                // make options for any object without them (and change icon acordingly)
                if (!haveOptions)
                {
                    hctCompressTextureFilterOptions::ConvertOptions& opt = filter->m_options.m_perTextureOptions.expandOne();
                    // copy settings from last
                    _getCurrentOptions( hWnd, opt );
                    opt.m_textureName = const_cast<char *>(textureName);

                    optionsIndices.pushBack(filter->m_options.m_perTextureOptions.getSize() - 1);

                    LV_ITEM item;
                    item.mask = LVIF_IMAGE;
                    item.iImage = fileBased? 2 : 3 ;
                    item.iItem = i;
                    item.iSubItem = 0;
                    ListView_SetItem( texListWnd, &item);
                }
            }
        }

        for (int oii=0; oii < optionsIndices.getSize(); ++oii)
        {
            options.pushBack( &filter->m_options.m_perTextureOptions[ optionsIndices[oii] ] );
        }
    }
}

static void _reflectCurrentOptions( HWND hWnd, hctCompressTextureFilterOptions::ConvertOptions& opt )
{
    ComboBox_SetCurSel( GetDlgItem( hWnd, IDC_COMPRESS_FORMAT ), opt.m_format);
    ComboBox_SetCurSel( GetDlgItem( hWnd, IDC_COMPRESS_QUALITY ), opt.m_quality);
    ComboBox_SetCurSel( GetDlgItem( hWnd, IDC_COMPRESS_MIPMAP ), opt.m_mipMapFilter);
    CheckDlgButton( hWnd, IDC_COMPRESS_FLIPX, (BOOL)opt.m_flipX);
    CheckDlgButton( hWnd, IDC_COMPRESS_FLIPY, (BOOL)opt.m_flipY);
    CheckDlgButton( hWnd, IDC_COMPRESS_USEORIGNAME, opt.m_useOriginalFilename);
}

static void _reflectCurrentOptions( HWND hWnd, int texIndex, hctCompressTextureFilter* filter )
{
    // find the texture options (if any)
    const char* texName = HK_NULL;
    if (texIndex < filter->m_listedFileTextures.getSize())
    {
        texName = filter->m_listedFileTextures[texIndex]->m_name;
    }
    else
    {
        texIndex -= filter->m_listedFileTextures.getSize();
        texName = filter->m_listedInplaceTextures[texIndex]->m_name;
    }

    if (texName)
    {
        for (int pti=0; pti < filter->m_options.m_perTextureOptions.getSize(); ++pti)
        {
            const char* oname = filter->m_options.m_perTextureOptions[pti].m_textureName;
            if (oname && (hkString::strCmp(oname, texName)==0))
            {
                // found it.
                hctCompressTextureFilterOptions::ConvertOptions& opt = filter->m_options.m_perTextureOptions[pti];
                _reflectCurrentOptions( hWnd, opt );
            }
        }
    }
}
static bool _toggleOptions( HWND hWnd, int texIndex, hctCompressTextureFilter* filter )
{
    // find the texture options (if any)
    const char* texName = HK_NULL;
    if (texIndex < filter->m_listedFileTextures.getSize())
    {
        texName = filter->m_listedFileTextures[texIndex]->m_name;
    }
    else
    {
        texIndex -= filter->m_listedFileTextures.getSize();
        texName = filter->m_listedInplaceTextures[texIndex]->m_name;
    }

    if (texName)
    {
        for (int pti=0; pti < filter->m_options.m_perTextureOptions.getSize(); ++pti)
        {
            const char* oname = filter->m_options.m_perTextureOptions[pti].m_textureName;
            if (oname && (hkString::strCmp(oname, texName)==0))
            {
                filter->m_options.m_perTextureOptions.removeAtAndCopy(pti);
                return false; // no options now
            }
        }

        // if we get this far the it does not have options yet
        hctCompressTextureFilterOptions::ConvertOptions& opt = filter->m_options.m_perTextureOptions.expandOne();
        _getCurrentOptions(hWnd, opt);
        opt.m_textureName = const_cast<char *>(texName);

        return true; // has options now
    }

    return false;
}

INT_PTR CALLBACK hkFilterCompressTexturesDialogProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    hctCompressTextureFilter* filter = reinterpret_cast<hctCompressTextureFilter*>( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA)) ;

    switch( message )
    {
    case WM_INITDIALOG:
        {
            filter = (hctCompressTextureFilter*)lParam;
            SetWindowLongPtr( hWnd, GWLP_USERDATA, (LONG_PTR)lParam ); // so that it can be retrieved later

            HIMAGELIST hImageList = ImageList_LoadImage( hInstance, MAKEINTRESOURCE(IDB_TEXTURETYPES_BITMAP), 16, 1, RGB(255,255,255), IMAGE_BITMAP, LR_CREATEDIBSECTION );

            // make our image of the current root inc processing up to our filter
            filter->getFilterManager()->getInputContentsToCurrentFilter( &filter->m_optionSceneData, filter->m_optionSceneDataTracker);

            hkStringOld infoText;
            infoText.printf("This filter uses the NVIDIA Texture Tools\nCopyright NVIDIA Corporation 2007\nVersion %d", nvtt::version() );
            SetDlgItemText( hWnd, IDC_COMPRESS_STATIC_COPYRIGHT, infoText.cString());

            hkxScene* scenePtr = filter->m_optionSceneData->findObject<hkxScene>();
            HWND texListWnd = GetDlgItem( hWnd, IDC_COMPRESS_TEXTURE_LIST);

            ListView_SetImageList( texListWnd, hImageList, LVSIL_SMALL /*LVSIL_STATE*/);
            LV_COLUMN col;
            col.mask = LVCF_WIDTH;
            col.cx = 139;
            ListView_InsertColumn( texListWnd, 0, &col);

            LVGROUP grp;
            grp.mask = LVGF_HEADER;
            grp.pszHeader = L"File Textures";
            ListView_InsertGroup(texListWnd, 0, &grp);
            grp.pszHeader = L"Inplace Textures";
            ListView_InsertGroup(texListWnd, 1, &grp);

            ListView_EnableGroupView(texListWnd, TRUE);

            filter->m_listedFileTextures.setSize(0);
            filter->m_listedInplaceTextures.setSize(0);

            bool hadSomeOptions= false;
            if (scenePtr != HK_NULL)
            {
                hkArray<hkxMaterial::TextureType> infoHints;
                hkArray<const char*> fileHints;

                hctFilterTextureUtils::findFileTextures( *scenePtr, filter->m_listedFileTextures, &infoHints );
                hctFilterTextureUtils::findInplaceTextures( *scenePtr, filter->m_listedInplaceTextures, &infoHints );

                int numFileTextures = 0;
                hkArray<const char*> textureNames;
                for (int t=0; t < filter->m_listedFileTextures.getSize(); ++t)
                {
                    const char* tname = filter->m_listedFileTextures[t]->m_name;
                    if (tname)
                    {
                        textureNames.pushBack(tname);
                        fileHints.pushBack(filter->m_listedFileTextures[t]->m_filename );
                        ++numFileTextures;
                    }
                    else
                    {
                        filter->m_listedFileTextures.removeAtAndCopy(t);
                        infoHints.removeAtAndCopy(t);
                    }
                }

                for (int tt=0; tt < filter->m_listedInplaceTextures.getSize(); ++tt)
                {
                    const char* tname = filter->m_listedInplaceTextures[tt]->m_name;
                    if (tname)
                    {
                        textureNames.pushBack(tname);
                        fileHints.pushBack(filter->m_listedInplaceTextures[tt]->m_originalFilename );
                    }
                    else
                    {
                        filter->m_listedInplaceTextures.removeAtAndCopy(tt);
                        infoHints.removeAtAndCopy(tt + numFileTextures);
                    }
                }

                for (int tn=0; tn < textureNames.getSize(); ++tn)
                {
                    bool hasOptions = false;
                    for (int tt=0; tt < filter->m_options.m_perTextureOptions.getSize(); ++tt)
                    {
                        if (filter->m_options.m_perTextureOptions[tt].m_textureName && hkString::strCmp( textureNames[tn], filter->m_options.m_perTextureOptions[tt].m_textureName) ==0 )
                        {
                            hasOptions = true;
                            hadSomeOptions = true;
                            break;
                        }
                    }

                    LV_ITEM item;
                    item.mask = LVIF_IMAGE | LVIF_TEXT | LVIF_STATE | LVIF_GROUPID;
                    item.iItem = tn;
                    item.iSubItem = 0;
                    hkStringOld fullText;
                    hkStringOld pathHint;
                    int plen = hkString::strLen(fileHints[tn]);
                    pathHint = fileHints[tn];
                    if (plen > 10)
                    {
                        int justFilenameA = pathHint.lastIndexOf('\\');
                        int justFilenameB = pathHint.lastIndexOf('/');
                        int lastSlash = hkMath::max2<int>( justFilenameA, justFilenameB );
                        pathHint = (lastSlash > 0? hkStringOld("...") : hkStringOld("")) + pathHint.substr(lastSlash);
                    }

                    fullText.printf( "%s, [%s:%s]", textureNames[tn], hctFilterTextureUtils::hintToText( infoHints[tn]), pathHint.cString() );
                    item.pszText = const_cast<char*>( fullText.cString() );
                    item.state = item.stateMask = 0;
                    item.iGroupId = tn < numFileTextures? 0 : 1;
                    item.iImage = tn < numFileTextures? (hasOptions? 2 : 0) : (hasOptions? 3 : 1);
                    ListView_InsertItem( texListWnd, &item);
                }
            }

            CheckDlgButton( hWnd, IDC_COMPRESS_APPLYTOALL, !hadSomeOptions );
            EnableWindow( texListWnd, hadSomeOptions );

            SetDlgItemTextW( hWnd, IDC_COMPRESS_PATH, hkUtf8::WideFromUtf8(filter->m_options.m_outputTexturePath));
            CheckDlgButton( hWnd, IDC_COMPRESS_OVERWRITE_ORIG, (BOOL)filter->m_options.m_allowOverwrite);

            HWND formatCombo = GetDlgItem( hWnd, IDC_COMPRESS_FORMAT);
            HWND qualityCombo = GetDlgItem( hWnd, IDC_COMPRESS_QUALITY);
            HWND mipmapCombo = GetDlgItem( hWnd, IDC_COMPRESS_MIPMAP);
            ComboBox_AddString( formatCombo, "RGB");
            ComboBox_AddString( formatCombo, "DXT1");
            ComboBox_AddString( formatCombo, "DXT1a");
            ComboBox_AddString( formatCombo, "DXT3");
            ComboBox_AddString( formatCombo, "DXT5");
            ComboBox_AddString( formatCombo, "DXT5n");
            ComboBox_AddString( formatCombo, "BC1");
            ComboBox_AddString( formatCombo, "BC1a");
            ComboBox_AddString( formatCombo, "BC2");
            ComboBox_AddString( formatCombo, "BC3");
            ComboBox_AddString( formatCombo, "BC3n");
            ComboBox_AddString( formatCombo, "BC4");
            ComboBox_AddString( formatCombo, "BC5");

            ComboBox_AddString( qualityCombo, "Fastest");
            ComboBox_AddString( qualityCombo, "Normal");
            ComboBox_AddString( qualityCombo, "Production");
            ComboBox_AddString( qualityCombo, "Highest");

            ComboBox_AddString( mipmapCombo, "No Mipmaps");
            ComboBox_AddString( mipmapCombo, "Box");
            ComboBox_AddString( mipmapCombo, "Triangle");
            ComboBox_AddString( mipmapCombo, "Kaiser");

            hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
            _getCurrentSelectedOptions( hWnd, options, filter );
            _reflectCurrentOptions( hWnd, *(options[0]) );

            return TRUE; // did handle it
        }

    case WM_COMMAND: // UI Changes
        {
            switch ( LOWORD( wParam ) )
            {
            case IDC_COMPRESS_APPLYTOALL:
                {
                    HWND texListWnd = GetDlgItem( hWnd, IDC_COMPRESS_TEXTURE_LIST);
                    if( IsDlgButtonChecked( hWnd, IDC_COMPRESS_APPLYTOALL ) == TRUE )
                    {
                        EnableWindow( texListWnd, FALSE);
                    }
                    else
                    {
                        EnableWindow( texListWnd, TRUE);
                    }

                    hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                    _getCurrentSelectedOptions( hWnd, options, filter );
                    _reflectCurrentOptions( hWnd, *(options[0]) );

                    break;
                }

            case IDC_COMPRESS_USEORIGNAME:
                {
                    bool useOrig = IsDlgButtonChecked( hWnd, IDC_COMPRESS_USEORIGNAME ) == TRUE;
                    hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                    _getCurrentSelectedOptions( hWnd, options, filter );
                    for (int oi=0; oi < options.getSize(); ++oi)
                    {
                        options[oi]->m_useOriginalFilename = useOrig;
                    }

                    break;
                }

            case IDC_COMPRESS_FORMAT:
                {
                    HWND comboBox = (HWND)lParam;
                    if (HIWORD(wParam) == CBN_SELCHANGE)
                    {
                        int formatValue = ComboBox_GetCurSel(comboBox);

                        hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                        _getCurrentSelectedOptions( hWnd, options, filter );
                        for (int oi=0; oi < options.getSize(); ++oi)
                        {
                            options[oi]->m_format = (hctCompressTextureFilterOptions::OutputFormat)formatValue;
                        }
                    }
                    break;
                }

            case IDC_COMPRESS_QUALITY:
                {
                    HWND comboBox = (HWND)lParam;
                    if (HIWORD(wParam) == CBN_SELCHANGE)
                    {
                        int qualityValue = ComboBox_GetCurSel(comboBox);

                        hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                        _getCurrentSelectedOptions( hWnd, options, filter );
                        for (int oi=0; oi < options.getSize(); ++oi)
                        {
                            options[oi]->m_quality = hctCompressTextureFilterOptions::OutputQuality(qualityValue);
                        }
                    }
                    break;
                }

            case IDC_COMPRESS_MIPMAP:
                {
                    HWND comboBox = (HWND)lParam;
                    if (HIWORD(wParam) == CBN_SELCHANGE)
                    {
                        int mipValue = ComboBox_GetCurSel(comboBox);

                        hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                        _getCurrentSelectedOptions( hWnd, options, filter );
                        for (int oi=0; oi < options.getSize(); ++oi)
                        {
                            options[oi]->m_mipMapFilter = hctCompressTextureFilterOptions::MipmapFilter(mipValue);
                        }
                    }
                    break;
                }

            case IDC_COMPRESS_EXPLORE:
                {
                    // Open a browser so the user can choose a new path to replace the selected one.
                    wchar_t displayName[MAX_PATH];

                    LPMALLOC pMalloc;
                    SHGetMalloc(&pMalloc);

                    BROWSEINFOW pbi;
                    hkString::memSet( &pbi, 0, sizeof(pbi));
                    pbi.hwndOwner = hWnd;
                    pbi.lpszTitle = L"Please select an output for new file based textures";
                    pbi.ulFlags = BIF_USENEWUI;
                    pbi.pszDisplayName = displayName;

                    LPITEMIDLIST folders = SHBrowseForFolderW(&pbi);
                    if (folders && SHGetPathFromIDListW(folders, displayName) )
                    {
                        SetDlgItemTextW( hWnd, IDC_COMPRESS_PATH, displayName);
                    }

                    pMalloc->Free(folders);
                    pMalloc->Release();

                    break;
                }
            }
        }

    case WM_NOTIFY: // Listview state changes etc
        {
            int idCtrl = (int) wParam;
            LPNMHDR pnmh = (LPNMHDR) lParam;
            switch (idCtrl)
            {
            case IDC_COMPRESS_TEXTURE_LIST:
                {
                    switch (pnmh->code)
                    {
                    case LVN_ITEMCHANGING:
                        {
                            LPNMLISTVIEW pnmv = (LPNMLISTVIEW)pnmh;
                            if (pnmv->uChanged & LVIF_STATE)
                            {
                                int texIndex = pnmv->iItem;
                                bool selected = (pnmv->uNewState & LVIS_SELECTED) != 0;
                                if (selected)
                                {
                                    _reflectCurrentOptions(hWnd, texIndex, filter );
                                }
                            }

                            return FALSE; // will allow state change
                        }

                    case NM_DBLCLK:
                        {
                            LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE)pnmh;

                            bool hasOptions = _toggleOptions( hWnd, lpnmitem->iItem, filter );

                            // change image
                            LV_ITEM item;
                            item.mask = LVIF_IMAGE | LVIF_STATE;
                            item.iImage = lpnmitem->iItem < filter->m_listedFileTextures.getSize()? (hasOptions ? 2: 0) : (hasOptions? 3 : 1);
                            item.iItem = lpnmitem->iItem;
                            item.iSubItem = 0;
                            item.state = hasOptions? LVIS_SELECTED : 0; // select it if we have create options
                            item.stateMask = LVIS_SELECTED;
                            ListView_SetItem( pnmh->hwndFrom, &item);

                            // update the opt selection
                            hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                            _getCurrentSelectedOptions( hWnd, options, filter );
                            _reflectCurrentOptions( hWnd, *(options[0]) );

                        }
                    }

                    break;
                }
                break;

            case IDC_COMPRESS_FLIPX:
            case IDC_COMPRESS_FLIPY:
                {
                    bool checked = IsDlgButtonChecked( hWnd, idCtrl ) != 0;
                    hkArray<hctCompressTextureFilterOptions::ConvertOptions*> options;
                    _getCurrentSelectedOptions( hWnd, options, filter );
                    for (int oi=0; oi < options.getSize(); ++oi)
                    {
                        if (idCtrl == IDC_COMPRESS_FLIPX)
                        {
                            options[oi]->m_flipX = checked;
                        }
                        else
                        {
                            options[oi]->m_flipY = checked;
                        }
                    }
                    break;
                }
            }
        }
    }

    return FALSE;
}

HWND hctCompressTextureFilter::showOptions( HWND owner)
{
    if( m_optionsDialog )
    {
        hideOptions();
    }

    // dealloc previous
    if (m_optionSceneDataTracker)
    {
        m_optionSceneDataTracker->removeReference();
    }

    m_optionsDialog = CreateDialogParamW( hInstance, MAKEINTRESOURCEW( IDD_COMPRESS_DIALOG ),
        owner, hkFilterCompressTexturesDialogProc, (LPARAM) this );

    return m_optionsDialog;
}

void hctCompressTextureFilter::hideOptions()
{
    if( m_optionsDialog )
    {
        if( IsDlgButtonChecked( m_optionsDialog, IDC_COMPRESS_APPLYTOALL ) == TRUE )
        {
            m_options.m_perTextureOptions.setSize(1);
            m_options.m_perTextureOptions[0].m_textureName = HK_NULL;
            // leave rest as is
        }

        m_options.m_outputTexturePath = HK_NULL;
        hctGetDlgItemHkStringPtr(m_optionsDialog, IDC_COMPRESS_PATH, m_options.m_outputTexturePath);

        m_options.m_allowOverwrite = IsDlgButtonChecked(m_optionsDialog, IDC_COMPRESS_OVERWRITE_ORIG) != 0;


        DestroyWindow( m_optionsDialog );
    }

    m_optionsDialog = NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
