// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


/// Options detailing texture size reduction.
class hctCompressTextureFilterOptions
{
    public:

        HK_DECLARE_CLASS(hctCompressTextureFilterOptions, New, Reflect);

            /// Default constructor
        hctCompressTextureFilterOptions() { }

        //
        // Members
        //
    public:

        enum OutputFormat
        {
            OF_RGB = 0, // Don't compress, just make into DDS (and optionaly mipmap)
            OF_DXT1,
            OF_DXT1a,   // DXT1 with binary alpha.
            OF_DXT3,
            OF_DXT5,
            OF_DXT5n,   // Compressed HILO: R=0, G=x, B=0, A=y

            // DX10 formats.
            OF_BC1, // DXT1
            OF_BC1a,
            OF_BC2, // DXT3
            OF_BC3, // DXT5
            OF_BC3n,
            OF_BC4, // ATI1
            OF_BC5  // 3DC, ATI2
        };

        enum OutputQuality
        {
            OQ_Fastest = 0,
            OQ_Normal,
            OQ_Production,
            OQ_Highest
        };

        enum MipmapFilter
        {
            MF_NoMipmaps = 0,
            MF_Box,
            MF_Triangle,
            MF_Kaiser
        };

        struct ConvertOptions
        {
            HK_DECLARE_CLASS(ConvertOptions, New, Reflect)

            ConvertOptions() {}

            hkStringPtr m_textureName; // the texture these options are for

            hkEnum<OutputFormat, hkUint8> m_format;
            hkEnum<OutputQuality, hkUint8> m_quality;
            hkEnum<MipmapFilter, hkUint8> m_mipMapFilter;

            hkBool m_flipX;
            hkBool m_flipY;

            hkBool m_useOriginalFilename; // always use the original file as the source to load
        };

        // If sizeof m_options is 1, and texture name is null, then will be applied to all textures
        hkArray< struct ConvertOptions > m_perTextureOptions;

        hkStringPtr m_outputTexturePath; // where to place file based textures (path will be stripped and this added, along with new file ext (.dds))
        hkBool m_allowOverwrite;
};

HK_REFLECT_ENUM(/**/, hctCompressTextureFilterOptions::OutputFormat);
HK_REFLECT_ENUM(/**/, hctCompressTextureFilterOptions::OutputQuality);
HK_REFLECT_ENUM(/**/, hctCompressTextureFilterOptions::MipmapFilter);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
